%define _unpackaged_files_terminate_build 1

%define lvm2version 2.03.10
%define dmversion 1.02.173

%define _sbindir /sbin
%define usrsbindir %_prefix/sbin
%define _runtimedir /run
%define _lockdir /run/lock
%def_enable static

%def_enable selinux
%def_enable lvmpolld
%def_enable lvmlockd
%def_enable blkid_wiping
%def_disable lvmdbusd
%def_enable dmfilemapd
%def_enable thin
%def_enable vdo
%def_enable writecache
%def_enable cmirrord
%def_enable cmdlib

%if_enabled lvmlockd
 %def_enable lvmlockd_sanlock
 %def_enable lvmlockd_dlm
%endif

Summary: Userland logical volume management tools
Name: lvm2
Version: %lvm2version
Release: alt1
License: GPLv2+ AND LGPL-2.1+

Group: System/Base
Url: http://sources.redhat.com/lvm2
Source: %name-%version.tar

Source3: lvm2-monitor.init
Source5: blk-availability.init
Source6: lvm2-lvmpolld.init

Patch: %name-%version-%release.patch

Conflicts: liblvm

Requires: dmsetup  >= %{dmversion}-%{release}
Requires: dmeventd >= %{dmversion}-%{release}
Requires: liblvm2  = %{lvm2version}-%{release}

BuildRequires: gcc-c++
BuildRequires: libreadline-devel libtinfo-devel libudev-devel CUnit-devel
BuildRequires: libaio-devel
# libudev-devel >= 205 required for udev-systemd-background-jobs
BuildRequires: libudev-devel >= 205
BuildRequires: systemd-devel
%if_enabled thin
BuildRequires: thin-provisioning-tools >= 0.7.0
%endif
BuildRequires: autoconf-archive
%{?_enable_thin:BuildRequires: thin-provisioning-tools >= 0.5.4}
BuildRequires(pre): rpm-build-python3
%{?_enable_lvmdbusd:BuildRequires: python3-devel python3-module-setuptools python3-module-dbus python3-module-pyudev}
%{?_enable_static:BuildRequires: libreadline-devel-static libtinfo-devel-static libaio-devel-static}
%{?_enable_selinux:BuildRequires: libselinux-devel libsepol-devel}
%{?_enable_blkid_wiping:BuildRequires: libblkid-devel >= 2.23}
%{?_enable_lvmlockd_sanlock:BuildRequires: sanlock-devel >= 3.3.0}
%{?_enable_lvmlockd_dlm:BuildRequires: libdlm-devel >= 4.0.9}
%{?_enable_cmirrord:BuildRequires: libcorosync-devel}

%description
LVM2 includes all of the support for handling read/write operations
on physical volumes (hard disks, RAID-Systems, magneto optical, etc.,
multiple devices (MD), see mdadd(8) or even loop devices, see losetup(8)),
creating volume groups (kind of virtual disks) from one or more physical
volumes and creating one or more logical volumes (kind of logical
partitions) in volume groups.

%package static
Summary: Statically linked userland logical volume management tool
Group: System/Base
Requires: %name = %lvm2version-%release

%description static
This package contains statically linked LVM2 tool.

### liblvm* subpackages go here.

%package -n liblvm2
Summary: LVM2 shared libraries
License: LGPLv2
Group: System/Libraries
Requires: libdevmapper = %dmversion-%release
Requires: libdevmapper-event = %dmversion-%release

%description -n liblvm2
This package contains shred lvm2 libraries for applications.

%package -n liblvm2-devel
Summary: LVM2 development libraries and headers
Group: System/Libraries
License: LGPLv2
Requires: lvm2 = %lvm2version-%release
Requires: liblvm2 = %lvm2version-%release
Requires: libdevmapper-devel = %dmversion-%release

%description -n liblvm2-devel
This package contains files needed to develop applications that use
the lvm2 libraries.

### device-mapper subpackages go here.

%package -n libdevmapper
Version: %dmversion
Summary: Library of routines for device-mapper management
Group: System/Libraries
Provides: device-mapper-libs = %dmversion-%release

%description -n libdevmapper
Library of routines for device-mapper management.

%package -n libdevmapper-devel
Version: %dmversion
Summary: Header file for libdevmapper
Group: System/Libraries
Requires: libdevmapper = %dmversion-%release
Provides: device-mapper-devel = %dmversion-%release

%description -n libdevmapper-devel
Header files for libdevmapper.

%package -n libdevmapper-devel-static
Version: %dmversion
Summary: Static version of libdevmapper
Group: System/Libraries
Requires: libdevmapper-devel = %dmversion-%release

%description -n libdevmapper-devel-static
Static version of libdevmapper.

%package -n dmsetup
Version: %dmversion
Summary: Utilities for low level logical volume management
Group: System/Kernel and hardware
Requires: libdevmapper = %dmversion-%release
Requires: lsblk udev >= 150-alt4
Provides: device-mapper = %dmversion-%release

%description -n dmsetup
Utilities for low level logical volume management.

%package -n dmeventd
Version: %dmversion
Summary: Device-mapper event daemon
Group: System/Base
Requires: dmsetup = %dmversion-%release
Requires: libdevmapper-event = %dmversion-%release
Provides: device-mapper-event = %dmversion-%release

%description -n dmeventd
This package contains the dmeventd daemon for monitoring the state
of device-mapper devices.

%package -n libdevmapper-event
Summary: Device-mapper event daemon shared library
Version: %dmversion
License: LGPLv2
Group: System/Libraries
Requires: liblvm2  = %lvm2version-%release
Requires: libdevmapper = %dmversion-%release
Provides: device-mapper-event-libs  = %dmversion-%release

%description -n libdevmapper-event
This package contains the device-mapper event daemon shared library,
libdevmapper-event.

%package -n libdevmapper-event-devel
Summary: Development libraries and headers for the device-mapper event daemon
Version: %dmversion
License: LGPLv2
Group: System/Libraries
Requires: libdevmapper-event = %dmversion-%release
Requires: libdevmapper-devel = %dmversion-%release
Provides: device-mapper-event-devel = %dmversion-%release

%description -n libdevmapper-event-devel
This package contains files needed to develop applications that use
the device-mapper event library.

%package lockd
Summary: LVM locking daemon
Group: System/Base
Requires: %name = %lvm2version-%release
%{?_enable_lvmlockd_sanlock:Requires: sanlock}
%{?_enable_lvmlockd_dlm:Requires: dlm}

%description lockd
LVM commands use lvmlockd to coordinate access to shared storage.

%package cmirrord
Summary: Daemon for device-mapper-based clustered mirrors
Group: System/Base
Provides: cmirror = %lvm2version-%release
Provides: %name-cmirror = %lvm2version-%release
Requires: corosync >= 1.99.9
Requires: dmsetup = %dmversion-%release
Requires: resource-agents >= 3.9.5
 
%description cmirrord
Daemon providing device-mapper-based mirrors in a shared-storage cluster.

%package dbusd
Summary: LVM2 D-Bus daemon
License: GPLv2
Group: System/Base
Requires: %name = %lvm2version-%release
Requires: dbus

%description dbusd
Daemon for access to LVM2 functionality through a D-Bus interface.

%prep
%setup
%patch -p1
%ifarch %e2k
# as of lcc-1.21.24
sed -i '/-Wmissing-parameter-type/d' make.tmpl.in
%endif

%build
%autoreconf
export ac_cv_path_MODPROBE_CMD=%_sbindir/modprobe

%if_enabled static
%configure \
	--disable-readline \
	--disable-selinux \
	--disable-blkid_wiping \
	--disable-nls \
	--enable-static_link \
	ac_cv_lib_dl_dlopen=no \
	--with-optimisation="%optflags -Os" \
	--with-group= \
	--with-staticdir=%_sbindir \
	--with-user= \
	--disable-pkgconfig \
	--with-device-uid=0 \
	--with-device-gid=6 \
	--with-device-mode=0660 \
	--with-dmeventd-path="%_sbindir/dmeventd" \
	--with-default-pid-dir=%_runtimedir \
	--with-default-dm-run-dir=%_runtimedir \
	--with-default-run-dir=%_runtimedir/lvm \
	--with-default-locking-dir=%_lockdir/lvm \
	--disable-silent-rules

	#
%make_build libdm
%make_build lib
%make_build -C tools lvm.static
mv tools/lvm.static .
mv libdm/ioctl/libdevmapper.a .
%make clean
%endif # static

# dynamic

%configure \
	%{subst_enable selinux} \
	--disable-static_link \
	--enable-readline \
	--with-group= \
	--with-user= \
	--enable-pkgconfig \
	--with-device-uid=0 \
	--with-device-gid=6 \
	--with-device-mode=0660 \
	--enable-write_install \
	%{subst_enable cmdlib} \
	--with-usrlibdir=%_libdir \
	--with-usrsbindir=%usrsbindir \
	--enable-dmeventd \
	--with-udevdir=%_udevrulesdir \
	%{subst_enable lvmpolld} \
	%{subst_enable dmfilemapd} \
	%{subst_enable cmirrord} \
	--enable-udev_sync \
	%{subst_enable blkid_wiping} \
	%{?_enable_lvmlockd_dlm:--enable-lvmlockd-dlm --enable-lvmlockd-dlmcontrol} \
	%{?_enable_lvmlockd_sanlock:--enable-lvmlockd-sanlock} \
	%{?_enable_lvmdbusd:--enable-dbus-service} \
	%{?_enable_vdo:--with-vdo=internal --with-vdo-format=%_bindir/vdoformat} \
	%{?_enable_writecache:--with-writecache=internal} \
    --with-integrity=internal \
	--with-dmeventd-path="%_sbindir/dmeventd" \
	--with-systemdsystemunitdir=%_unitdir \
	--with-tmpfilesdir=%_tmpfilesdir \
	--with-default-pid-dir=%_runtimedir \
	--with-default-dm-run-dir=%_runtimedir \
	--with-default-run-dir=%_runtimedir/lvm \
	--with-default-locking-dir=%_lockdir/lvm \
	--disable-silent-rules

%make_build

%install
%makeinstall_std
%makeinstall_std install_system_dirs
%makeinstall_std install_systemd_units
%makeinstall_std install_systemd_generators
%makeinstall_std install_tmpfiles_configuration

chmod -R u+rwX %buildroot
%{?_enable_static:install -pm755 lvm.static %buildroot%_sbindir}

### device-mapper part

%{?_enable_static:install -pm755 libdevmapper.a %buildroot%_libdir/}

mkdir -p %buildroot/%_lib

# Relocate shared library from %_libdir/ to /%_lib/.
for f in `ls %buildroot%_libdir/libdevmapper.so`; do
	t=`objdump -p "$f" |awk '/SONAME/ {print $2}'`
	[ -n "$t" ]
	ln -sf ../../%_lib/"$t" "$f"
done

mv %buildroot%_libdir/libdevmapper.so.1.02 %buildroot/%_lib/
mv %buildroot%_libdir/libdevmapper-event.so.1.02 %buildroot/%_lib/

pushd %buildroot%_libdir
rm -f libdevmapper-event.so
ln -sf ../../%_lib/libdevmapper-event.so.1.02 ./libdevmapper-event.so
popd

# Fix pkgconfig file.
subst '/^Version:/ s/"\([^[:space:]]\+\)[^"]*"/\1/' %buildroot%_pkgconfigdir/*

# provide a symlink for devmapper.pc
ln -sf devmapper.pc %buildroot%_pkgconfigdir/libdevmapper.pc

### lvm2-monitor init script

mkdir -p %buildroot%_initdir
install -m 0755 %SOURCE3 %buildroot%_initdir/lvm2-monitor
install -m 0755 %SOURCE5 %buildroot%_initdir/blk-availability
install -m 0755 %SOURCE6 %buildroot%_initdir/lvm2-lvmpolld

%post
%if_enabled lvmpolld
%post_service lvm2-lvmpolld
%endif
%post_service blk-availability
%post_service lvm2-monitor

%preun
%preun_service lvm2-monitor
%if_enabled lvmpolld
%preun_service lvm2-lvmpolld
%endif
%preun_service blk-availability

%post lockd
%post_service lvmlockd

%preun lockd
%preun_service lvmlockd

%post dbusd
%post_service lvm2-lvmdbusd

%preun dbusd
%preun_service lvm2-lvmdbusd

%files
%doc README WHATS_NEW udev/12-dm-permissions.rules
%doc doc/*.txt
%_sbindir/*
%exclude %_sbindir/dmsetup
%exclude %_sbindir/dmstats
%exclude %_sbindir/blkdeactivate
%exclude %_sbindir/dmeventd
%{?_enable_static:%exclude %_sbindir/*.static}
%_mandir/man?/*
%exclude %_man8dir/dmsetup*
%exclude %_man8dir/dmstats*
%exclude %_man8dir/blkdeactivate*
%exclude %_man8dir/cmirrord*
%config(noreplace) %_sysconfdir/lvm/lvm.conf
%config(noreplace) %_sysconfdir/lvm/lvmlocal.conf
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/lvm/profile/*.profile
%_initdir/lvm2-monitor
%_unitdir/lvm2-monitor.service
%_unitdir/blk-availability.service
%_initdir/blk-availability
%_unitdir/lvm2-pvscan@.service
%_udevrulesdir/69-dm-lvm-metad.rules
%if_enabled lvmpolld
%_initdir/lvm2-lvmpolld
%_unitdir/lvm2-lvmpolld*
%endif
%if_enabled lvmlockd
%exclude %_sbindir/lvmlockd
%exclude %_sbindir/lvmlockctl
%exclude %_man8dir/lvmlockd*
%endif
/lib/systemd/system-generators/lvm2-activation-generator
%_tmpfilesdir/%name.conf
%dir %_sysconfdir/lvm
%dir %_sysconfdir/lvm/profile
%defattr(600,root,root,700)
%dir %_sysconfdir/lvm/backup
%dir %_sysconfdir/lvm/archive
%dir %_sysconfdir/lvm/cache
#%ghost %_lockdir/lvm
%ghost %_sysconfdir/lvm/cache/.cache

%if_enabled static
%files static
%_sbindir/*.static
%endif # static

%files -n liblvm2
%_libdir/liblvm2cmd.so.*

%files -n liblvm2-devel
%_libdir/liblvm2cmd.so
%_includedir/lvm2cmd.h

%files -n libdevmapper
/%_lib/libdevmapper.so.*

%files -n libdevmapper-devel
%_libdir/libdevmapper.so
%_includedir/libdevmapper.h
%_pkgconfigdir/*devmapper.*

%files -n libdevmapper-devel-static
%_libdir/libdevmapper.a

%files -n dmsetup
%doc WHATS_NEW_DM
%_sbindir/dmsetup
%_man8dir/dmsetup*
%_sbindir/blkdeactivate
%_man8dir/blkdeactivate*
%_sbindir/dmstats
%_man8dir/dmstats*
%_udevrulesdir/*
%exclude %_udevrulesdir/69-dm-lvm-metad.rules

%files -n dmeventd
%_sbindir/dmeventd
%_unitdir/dm-event.service
%_unitdir/dm-event.socket

%files -n libdevmapper-event
/%_lib/libdevmapper-event.so.*
%_libdir/libdevmapper-event-*.so*
%dir %_libdir/device-mapper
%_libdir/device-mapper/libdevmapper-event-*.so*

%files -n libdevmapper-event-devel
%_libdir/libdevmapper-event.so
%_includedir/libdevmapper-event.h
%_pkgconfigdir/devmapper-event.pc

%if_enabled lvmlockd
%files lockd
%_sbindir/lvmlockd
%_sbindir/lvmlockctl
%_man8dir/lvmlockd*
%_unitdir/lvmlock*
#%_initdir/lvmlock*
%endif

%if_enabled cmirrord
%files cmirrord
%usrsbindir/cmirrord
%_man8dir/cmirrord*
%_unitdir/lvm2-cmirrord.service
%endif

%if_enabled lvmdbusd
%files dbusd
%_sbindir/lvmdbusd
%_sysconfdir/dbus-1/system.d/com.redhat.lvmdbus1.conf
%_datadir/dbus-1/system-services/com.redhat.lvmdbus1.service
%_man8dir/lvmdbusd.*
%_unitdir/lvm2-lvmdbusd.service
%python3_sitelibdir/lvmdbusd
%endif

%changelog
