%global import_path github.com/lxc/lxd

#global __find_debuginfo_files %nil
%global _unpackaged_files_terminate_build 1

%set_verify_elf_method unresolved=no
#add_debuginfo_skiplist %go_root %_bindir

%define lxdgroup lxd
%define lxduser lxd

Name:		lxd
Version:	4.0.1
Release:	alt1
Summary:	LXD -- REST API, command line tool and OpenStack integration plugin for LXC.

Group:		Development/Other
License:	Apache-2.0
URL:		https://%import_path

Packager:	Denis Pynkin <dans@altlinux.ru>

Source0:	%name-%version.tar
Patch:		%name-%version-%release.patch
Source3:	lxd.default
Source4:	lxd.dnsmasq

# services
Source11:	lxd.service
Source12:	lxd.socket
Source13:	lxd-startup.service


ExclusiveArch:  %go_arches
BuildRequires(pre): rpm-build-golang

Requires:	shadow-submap
Requires:	lxc-libs
Requires:	lxcfs
Requires:	btrfs-progs
Requires:	lvm2
Requires:	squashfs-tools
Requires:	liblxd_sqlite3
Requires:	rsync
Requires:	iptables
Requires:	dnsmasq

BuildRequires: libcap-devel
BuildRequires: libuv-devel

BuildRequires: liblxd_sqlite3-devel
BuildRequires: libdqlite-devel
BuildRequires: libraft-devel
BuildRequires: libco-devel
BuildRequires: libudev-devel
BuildRequires: help2man
# Needed for manpages generation. Accessing to '/proc/self/...'
BuildRequires: /proc

BuildRequires:	lxc-devel
BuildRequires:	libacl-devel

%description
REST API, command line tool and OpenStack integration plugin for LXC.

%package devel
Summary: %summary
Group: Development/Other
BuildArch: noarch
Requires: golang

%description devel
%summary
This package contains library source intended for building other packages
which use the supplementary Go tools libraries with %import_path imports.


%prep
%setup -q
%patch -p1

%build
export BUILDDIR="$PWD/.build"
export IMPORT_PATH="%import_path"
export GOPATH="%go_path:$BUILDDIR"
export CGO_ENABLED=1

%golang_prepare

cd .build/src/%import_path

# Need to use a patched version of libsqlite
export TAGS="libsqlite3"
export CGO_CPPFLAGS="$(pkg-config --cflags lxd_sqlite3)"
export CGO_LDFLAGS="$(pkg-config --libs lxd_sqlite3)"
%golang_build lxd lxc fuidshift lxd-benchmark lxd-p2c lxc-to-lxd lxd/db

%install
export BUILDDIR="$PWD/.build"
export GOPATH="%go_path"

%golang_install

mkdir -p -- %buildroot/%go_root/bin
for f in %buildroot/%_bindir/*; do
	[ -x "$f" ] || continue
	f="${f##*/}"
	what="$(relative %_bindir/$f %go_root/bin/$f)"
	ln -s -- "$what" %buildroot/%go_root/bin/$f
done

# lxc-bridge
mkdir -p -- %buildroot%_libexecdir/lxd

# configuration
%__install -D %SOURCE3 %buildroot%_sysconfdir/sysconfig/lxd
# configuration for dnsmasq called in lxd-bridge
%__install -D %SOURCE4 %buildroot%_sysconfdir/lxd/dnsmasq.conf

#services
# systemd
mkdir -p %buildroot%_unitdir
cp -av %SOURCE11 %buildroot%_unitdir/
cp -av %SOURCE12 %buildroot%_unitdir/
cp -av %SOURCE13 %buildroot%_unitdir/

# install bash completion
mkdir -p %buildroot%_datadir/bash-completion/completions/
cp -av scripts/bash/lxd-client %buildroot%_datadir/bash-completion/completions/

# /var/{lib,log}/lxd
mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_logdir/%name

# Install the manpages
mkdir -p %buildroot%_man1dir
help2man %buildroot%_bindir/fuidshift -n "uid/gid shifter" --no-info --no-discard-stderr > %buildroot%_man1dir/fuidshift.1
help2man %buildroot%_bindir/lxc-to-lxd -n "Convert LXC containers to LXD" --no-info --version-string=%version --no-discard-stderr > %buildroot%_man1dir/lxc-to-lxd.1
help2man %buildroot%_bindir/lxd-benchmark -n "The container lightervisor - benchmark" --no-info --no-discard-stderr > %buildroot%_man1dir/lxd-benchmark.1
%buildroot%_bindir/lxd manpage %buildroot%_man1dir/
%buildroot%_bindir/lxc manpage %buildroot%_man1dir/

%pre
%_sbindir/groupadd -r -f %lxdgroup 2>/dev/null || :
%_sbindir/useradd  -r -g %lxdgroup -c "LXD daemon" \
   -s /dev/null -d /dev/null %lxduser 2>/dev/null || :

%files
%doc AUTHORS COPYING
%_bindir/*
%go_root/bin/*
%attr(0751,%lxduser,%lxdgroup) %dir %_localstatedir/%name
%attr(0751,%lxduser,%lxdgroup) %dir %_logdir/%name
#dir %_libexecdir/lxd
#_libexecdir/lxd/*

%_unitdir/*

%_datadir/bash-completion/completions/*

%config(noreplace) %_sysconfdir/sysconfig/*
%dir %_sysconfdir/lxd
%config(noreplace) %_sysconfdir/lxd/dnsmasq.conf

%_man1dir/*

%files devel
%go_path/src/*
%exclude %go_path/src/%import_path/vendor
%exclude %go_path/src/%import_path/go.mod
%exclude %go_path/src/%import_path/go.sum

%changelog
