# Features/TODO:
#	add systemd init support
#       use xz for large archives in /usr/share/mailman/cron/nightly_gzip
Name: mailman
Version: 2.1.37
Release: alt1
Epoch: 5

%define mm_user %name
%define mm_group %name
%define mm_lockdir %_lockdir/%name
%define mm_logdir %_logdir/%name
%define mm_rundir %_var/run/%name
%define mm_spooldir %_spooldir/%name

%define crontabdir %_sysconfdir/cron.d
%define logrotate %_sysconfdir/logrotate.d
%define ngxconfdir %_sysconfdir/nginx/sites-available.d
%define confdir %_sysconfdir/%name
%define _prefix /usr/share/%name
%define _exec_prefix %_libexecdir/%name
%define _var_prefix %_localstatedir/%name

Summary: Mailing list manager with built in web access
License: GPL-2.0-or-later
Group: System/Servers
Url: https://www.list.org/

# http://prdownloads.sourceforge.net/%name/%name-%version.tar.tgz
# http://bazaar.launchpad.net/~mailman-coders/mailman/2.1
Source: %name-%{version}.tar
# ALT Linux cumulative patch
Patch:  %name-%{version}-%release-alt.patch

PreReq: sendmail-common
Requires: python, webserver-common, MTA
BuildRequires: python-devel python-module-dns

BuildRequires(pre): python
AutoProv: yes, nopython

BuildRequires(pre): rpm-macros-webserver-common
BuildRequires(pre): rpm-macros-apache2

%add_python_req_skip Defaults Mailman mm_config
%define _python_compile_include %_datadir/%name

%description
Mailman, the GNU Mailing List Management System, is a mailing list
management system written mostly in Python. Features:

- Web based list administration for nearly all tasks.  Web based
  subscriptions and user configuration management. A customizable
  "home page" for each mailing list.
- Privacy features such as moderation, open and closed list
  subscription policies, private membership rosters, and sender-based
  filters.
- Automatic web based archiving built-in with support for private
  and public archives, and hooks for external archivers.
- Per-user configuration optional digest delivery for either
  MIME-compliant or RFC 1153 style "plain text" digests.
- Integrated mail/Usenet gateways.
- Integrated auto-replies.
- Majordomo-style email based commands.
- Integrated bounce detection within an extensible framework.
- Integrated spam detection, and MIME-based content filtering.
- An extensible mail delivery pipeline.
- Support for virtual domains.

See the Mailman home site for current status, including new releases
and known problems: %url


%package apache2
Group: System/Servers
Summary: Mailman configuration for Apache2
BuildArch: noarch
Requires: %name = %EVR
Requires: apache2-base

%description apache2
Mailman configuration files for Apache2

%package nginx
Group: System/Servers
Summary: Mailman configuration for nginx
BuildArch: noarch
Requires: %name = %EVR
Requires: nginx spawn-fcgi

%description nginx
Mailman configuration files for nginx

%package docs
Group: System/Servers
Summary: Mailing list manager with built in web access
BuildArch: noarch

%description docs
Documentation for mailman

%prep
%setup -q -n %name-%{version}
# ALT Linux cumulative patch
%patch -p1

install -pD -m644 alt-linux/mm_cfg.py Mailman/mm_cfg.py.dist.in
install -pD -m644 alt-linux/README.ALT README.ALT

sed -i -e 's,@LOCKFILE@,%mm_lockdir/master-qrunner,g' cron/crontab.in.in

# Debian patches
# see http://packages.qa.debian.org/m/mailman.html
for patch in \
10_wrapper_uid.patch \
51_nocompile.pyc.patch \
52_check_perms_lstat.patch \
53_disable_addons.patch \
63_update_default_server_language.patch \
66_donot_let_cache_html_pages.patch \
79_archiver_slash.patch \
92_reproducible_build.patch
do
	echo "Patch ($patch):"
	patch -s -p1 < debian/patches/$patch
done

# fix python shebangs
find . -type f -print0 |
	xargs -r0 grep -lZ '^#![[:space:]]*/usr/bin/.*python$' -- |
	xargs -r0 sed -E -i '1 s@^(#![[:space:]]*)/usr/bin/(env[[:space:]]+)?python$@\1%__python@' --

touch src/*.c

%build
%autoreconf
%configure \
	--with-var-prefix=%_var_prefix \
	--with-config-dir=%confdir \
	--with-lock-dir=%mm_lockdir \
	--with-log-dir=%mm_logdir \
	--with-pid-dir=%mm_rundir \
	--with-queue-dir=%mm_spooldir \
	--with-python=%__python \
	--with-mail-groupfile=%confdir/mail.groups \
	--with-cgi-groupfile=%confdir/cgi.groups \
	--with-mailhost=localhost.localdomain \
	--with-urlhost=localhost.localdomain \
	--without-permcheck

# rebuild mailman.pot
%make -C messages potfile

%make_build OPT="$RPM_OPT_FLAGS"

%install
find bin -type f -print0 |
	xargs -r0 grep -Zl '%__python$' |
	xargs -r0 subst 's|%__python$|%__python -O|g'

%make_install doinstall \
	DESTDIR=%buildroot \
	prefix=%prefix \
	exec_prefix=%_exec_prefix \
	var_prefix=%_var_prefix

chmod -R go-w %buildroot{%prefix,%_exec_prefix}
find %buildroot{%prefix,%_exec_prefix} -type d -print0 |
	xargs -r0 chmod a-s,o-r
chmod a-s,go-r %buildroot%_var_prefix

# Create directories we'll use for log and spool files. Create links
install -d -m3771 %buildroot%mm_logdir
install -d -m2770 %buildroot%mm_spooldir
install -d -m2771 %buildroot%mm_spooldir/{archive,bounces,commands,in,news,out,qfiles,retry,shunt,virgin}

ln -rs %buildroot%mm_logdir %buildroot%_var_prefix/logs
ln -rs %buildroot%mm_spooldir %buildroot%_var_prefix/qfiles

# Copy icons to the web server's icons directory.
mkdir -p %buildroot%webserver_iconsdir
rm -rf %buildroot%webserver_iconsdir
mv %buildroot%prefix/icons %buildroot%webserver_iconsdir
ln -rs %buildroot%webserver_iconsdir %buildroot%prefix/icons

# Install the logrotate control file.
install -pD -m644 alt-linux/%name.logrotate \
	%buildroot%logrotate/%name

# Install the httpd2 configuration file.
install -d %buildroot%apache2_mods_start
install -d %buildroot%apache2_sites_available
install -d %buildroot%apache2_sites_start
install -d %buildroot%apache2_ports_start
install -p -m644 alt-linux/apache2.mods-start %buildroot%apache2_mods_start/%name.conf
install -p -m644 alt-linux/apache2.sites-start %buildroot%apache2_sites_start/%name.conf
install -p -m644 alt-linux/apache2.ports-start %buildroot%apache2_ports_start/%name.conf
sed -e 's|@CODEDIR@|%_exec_prefix|g;s|@DATADIR@|%_var_prefix|g' \
	alt-linux/apache2.sites-available > %buildroot%apache2_sites_available/%name.conf

# Install the nginx configuration file.
install -pD -m644 /dev/null %buildroot%ngxconfdir/%name.conf
sed -e 's|@CODEDIR@|%_exec_prefix|g;s|@DATADIR@|%_var_prefix|g' \
	alt-linux/%name-nginx.conf > %buildroot%ngxconfdir/%name.conf

# Install crontab file
install -pD -m644 cron/crontab.in %buildroot%crontabdir/%name

# Install init script
install -pD -m755 misc/mailman %buildroot%_initdir/%name

# Install service file.
mkdir -p %buildroot%_unitdir
sed 's|@prefix@|%_prefix|g;s|@PID_DIR@|%mm_rundir|g' \
	< alt-linux/%name.service.in > %buildroot%_unitdir/%name.service

# Install config files for postfix
install -pD -m644 alt-linux/mm_config.py %buildroot%confdir/mm_config.py
touch %buildroot%confdir/mm_config.py{c,o}
touch %buildroot%confdir/{aliases,virtual-mailman}{,.cdb}
touch %buildroot%_var_prefix/data/last_mailman_version

cat <<EOF > %buildroot%confdir/mail.groups
mail
postman
%mm_group
EOF

cat <<EOF > %buildroot%confdir/cgi.groups
apache2
_spawn_fcgi
EOF

# Install man pages
install -m755 -pd %buildroot%_man8dir
install -m644 debian/manpages/*.8 %buildroot%_man8dir/

# Install lockdir and piddir
install -m755 -pd %buildroot%mm_lockdir
install -m755 -pd %buildroot%mm_rundir

# Install tmpfiles.d(5) rules.
mkdir -p %buildroot%_tmpfilesdir
cat > %buildroot%_tmpfilesdir/%name.conf <<'EOF'
d %mm_lockdir 0770 root %mm_group
d %mm_rundir 0770 root %mm_group
EOF

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
cp -a ACKNOWLEDGMENTS BUGS FAQ INSTALL NEWS README* STYLEGUIDE.txt TODO UPGRADING \
	misc/sitelist.cfg tests doc/mailman-{admin,install,member}{,.{pdf,txt}} \
	%buildroot%docdir/

# Remove unused files
rm -f %buildroot%confdir/sitelist.cfg
rm -rf %buildroot%_datadir/%name/tests

%define _unpackaged_files_terminate_build 1

%pre
/usr/sbin/groupadd -rf %mm_group ||:
/usr/sbin/useradd -M -r -s /dev/null -c "GNU Mailing List Manager" \
	-d %_var_prefix -g %mm_group %mm_user &>/dev/null ||:

%post
%post_service mailman
# Fix file permissions
if [ -f %_var_prefix/data/last_mailman_version ]; then
	chown %mm_user:%mm_group %_var_prefix/data/last_mailman_version ||:
	chmod 644 %_var_prefix/data/last_mailman_version ||:
	echo "Update mailman's database:"
	%_prefix/bin/update ||:
else
	%_prefix/bin/update &> /dev/null ||:
fi

%preun
%preun_service mailman

%triggerin -- postfix
# Generate aliases
%_prefix/bin/genaliases

%triggerpostun -- mailman = 5:2.1.12-alt2.1.1
echo "WARNING! Upgrading from legacy version!"
echo "Please check README.ALT for possible"
echo "problems and solutions."

%triggerun -- mailman < 5:2.1.9-alt2
if [ $1 != 0 ]; then
# Move old configs and passwords and change group
	for file in aliases virtual-mailman mm_config.py; do
		if [ -f %_var_prefix/etc/$file ]; then
			mv %_var_prefix/etc/$file %confdir/$file ||:
			chgrp %mm_group %confdir/$file ||:
		fi
	done
	for file in adm.pw creator.pw; do
		if [ -f %_var_prefix/data/$file ]; then
			mv %_var_prefix/data/$file %confdir/$file ||:
			chgrp %mm_group %confdir/$file ||:
		fi
	done
# Change paths in Postfix config
	if [ -f %_sysconfdir/postfix/main.cf ]; then
		sed  -i -e 's,%_var_prefix/etc/aliases,%confdir/aliases,g' \
			-e 's,%_var_prefix/etc/virtual-mailman,%confdir/virtual-mailman,g' \
			%_sysconfdir/postfix/main.cf ||:
	fi
# Move lockfiles and pidfile
	for file in %_var_prefix/locks/*; do
		[ -f $file ] && mv $file %mm_lockdir/ ||:
	done
	[ -f %_var_prefix/data/master-qrunner.pid ] && \
		mv -f %_var_prefix/data/master-qrunner.pid %mm_rundir/ ||:
fi
# Restart mailman again with configs at the new place
%post_service mailman

%files
%dir %docdir
%docdir/[^m]*
%config(noreplace) %logrotate/%name
%config(noreplace) %crontabdir/%name
%attr(0755,root,root) %_initdir/%name
%_unitdir/%name.service
%webserver_iconsdir/*
%dir %prefix
%prefix/bin
%prefix/cron
%prefix/icons
%prefix/Mailman
%prefix/messages
%prefix/pythonlib
%prefix/scripts
%prefix/templates
%_man8dir/*
%dir %attr(0770,root,%mm_group) %mm_lockdir
%dir %attr(0770,root,%mm_group) %mm_rundir
%_tmpfilesdir/%name.conf

%defattr(-,root,%mm_group,-)
%_exec_prefix
%dir %attr(0751,root,%mm_group) %_var_prefix
%dir %_var_prefix/archives
%dir %_var_prefix/archives/*
%dir %_var_prefix/spam
%dir %_var_prefix/lists
%dir %_var_prefix/data
%dir %attr(2771,root,%mm_group) %confdir
%config(noreplace) %attr(0664,root,%mm_group) %confdir/mm_config.py
%config(noreplace) %attr(0664,root,%mm_group) %confdir/aliases
%config(noreplace) %attr(0664,root,%mm_group) %confdir/virtual-mailman
%config(noreplace) %attr(0664,root,%mm_group) %confdir/*groups
%attr(0644,root,%mm_group) %ghost %config(noreplace,missingok) %verify(not md5 mtime size) %confdir/*.cdb
%attr(0644,root,%mm_group) %ghost %config(noreplace,missingok) %verify(not md5 mtime size) %confdir/mm_config.py[co]
%attr(0644,%mm_user,%mm_group) %ghost %config(noreplace,missingok) %verify(not md5 mtime size) %_var_prefix/data/last_mailman_version
%_var_prefix/logs
%_var_prefix/qfiles
%mm_logdir
%dir %mm_spooldir
%dir %mm_spooldir/*

%files apache2
%config(noreplace) %apache2_mods_start/%name.conf
%config(noreplace) %apache2_sites_available/%name.conf
%config(noreplace) %apache2_sites_start/%name.conf
%config(noreplace) %apache2_ports_start/%name.conf

%files nginx
%config(noreplace) %ngxconfdir/%name.conf

%files docs
%dir %docdir
%docdir/mailman-*

%changelog
