Name: make
Version: 4.2.1
Release: alt6
Epoch: 2

Summary: A GNU tool which simplifies the build process for users
License: GPLv3+
Group: Development/Other
Url: http://www.gnu.org/software/make/

# ftp://ftp.gnu.org/gnu/make/make-%version.tar.bz2
Source: make-%version.tar
Patch01: make-4.2.1-alt-getcwd.patch
Patch02: make-4.2.1-alt-job_slots.patch
Patch03: make-4.0-rh-newlines.patch
Patch04: make-4.0-rh-weird-shell.patch
Patch05: make-4.2.1-upstream-compat.patch
Patch06: make-4.2.1-upstream-glob-compat.patch
Patch07: make-4.2.1-alt-disable-test-output-sync.patch

BuildRequires: /proc
BuildRequires: makeinfo

%description
A GNU tool for controlling the generation of executables and other
non-source files of a program from the program's source files.
Make allows users to build and install packages without any significant
knowledge about the details of the build process.  The details about
how the program should be built are provided for make in the program's
makefile.

%prep
%setup
%patch01 -p1
%patch02 -p1
%patch03 -p1
%patch04 -p1
%patch05 -p1
%patch06 -p1
%patch07 -p2

sed -i \
	-e 's,^AM_INIT_AUTOMAKE(\[1\.15 ,AM_INIT_AUTOMAKE([1.14.1 ,' \
	configure.ac

find -type f -name \*.orig -delete -print
rm doc/*.info*

%build
%autoreconf

# Enable mkstemp explicitly, not rely on configure (Owl).
export ac_cv_func_mkstemp=yes
%configure
%make_build

%install
%makeinstall_std
ln -sf make %buildroot%_bindir/gmake

%find_lang %name

%check
%make_build -k check

%files -f %name.lang
%_bindir/*
%_mandir/man?/*
%_infodir/*.info*
%doc AUTHORS NEWS README

%changelog
