%def_disable cluster
%define _sbindir /sbin
%define nowarn -Wno-implicit-fallthrough -Wno-format-truncation -Wno-format-overflow

Name: mdadm
Version: 4.1
Release: alt1

Summary: A tool for managing Soft RAID under Linux
License: GPLv2+
Group: System/Configuration/Hardware
Url: http://neil.brown.name/blog/mdadm

# http://git.altlinux.org/gears/m/mdadm.git
Source: %name-%version-%release.tar

BuildRequires: binutils-devel
%{?_enable_cluster:BuildRequires: libcorosync2-devel libdlm-devel}

# due to /lib/udev/rules.d/64-md-raid.rules
Conflicts: udev < 151

# Pull in the tool subpackage on a package update, but
# allow it to be installed individually
Requires: %name-tool = %version-%release

%description
mdadm is a program that can be used to create, manage, and monitor
Linux MD (Software RAID) devices.

As such is provides similar functionality to the raidtools packages.
The particular differences to raidtools is that mdadm is a single
program, and it can perform (almost) all functions without a
configuration file (that a config file can be used to help with
some common tasks).

%package tool
Summary: Primary '%name' command line tool for MD arrays maintenance
Group: System/Configuration/Hardware
%description tool
%summary

%package doc
Summary: Optional documentation for %name
Group: Documentation
BuildArch: noarch
%description doc
%summary

%prep
%setup -n %name-%version-%release

%build
%make_build mdadm mdmon CXFLAGS='%optflags %nowarn' SYSCONFDIR='%_sysconfdir'
bzip2 -9fk ChangeLog

%install
%makeinstall_std install-systemd MANDIR=%_mandir BINDIR=%_sbindir SYSTEMD_DIR=%_unitdir
install -pD -m755 alt/mdadm.init %buildroot%_initdir/mdadm
install -pD -m755 misc/syslog-events %buildroot%_sbindir/mdadm-syslog-events
install -pD -m600 alt/mdadm.conf %buildroot%_sysconfdir/mdadm.conf.sample
touch %buildroot%_sysconfdir/mdadm.conf
# install -pD -m644 alt/mdadm.service %buildroot%_unitdir/mdadm.service
ln -r -s %buildroot%_unitdir/mdmonitor.service %buildroot%_unitdir/mdadm.service

install -pD -m755 alt/checkarray %buildroot%_datadir/mdadm/checkarray
install -pD -m644 alt/mdadm.sysconfig %buildroot%_sysconfdir/sysconfig/mdadm
install -pD -m644 alt/mdadm.crond %buildroot%_sysconfdir/cron.d/mdadm


%post -f alt/raidtabtomdadm.sh
%post_service mdadm

%preun
%preun_service mdadm

%files
%_sbindir/mdadm-syslog-events
%_sbindir/mdmon
%_man8dir/mdmon.*
%config %_sysconfdir/mdadm.conf.sample
%config(noreplace) %_sysconfdir/sysconfig/mdadm
%_sysconfdir/cron.d/mdadm
%_initdir/mdadm
%_datadir/mdadm/
/lib/udev/rules.d/01-md-raid-creating.rules
/lib/udev/rules.d/63-md-raid-arrays.rules
/lib/udev/rules.d/64-md-raid-assembly.rules
/lib/udev/rules.d/69-md-clustered-confirm-device.rules
%_unitdir/*
/lib/systemd/system-shutdown/mdadm.shutdown

%files tool
%_sbindir/mdadm
%_man8dir/mdadm.*
%_man4dir/md.*
%_man5dir/mdadm.conf.*
%ghost %config(noreplace,missingok) %_sysconfdir/mdadm.conf

%files doc
%doc TODO ChangeLog.* mdadm.conf-example ANNOUNCE-%version alt/README*

%changelog
