%define ver_major 3.20

Name: meld
%define xdg_name org.gnome.%name
Version: %ver_major.1
Release: alt1

Summary: Meld Diff Viewer
License: %gpl2plus
Group: Text tools
Url: http://meldmerge.org/

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildArch: noarch

Requires: typelib(GtkSource) = 3.0

BuildRequires(pre): rpm-build-licenses rpm-build-gir rpm-build-python3
BuildRequires: intltool yelp-tools python3-devel

%description
Meld is a visual diff and merge tool. It lets you compare two or three
files, and updates the comparisons while you edit them in-place. You
can also compare folders, launching comparisons of individual files as
desired. Last but by no means least, Meld lets you work with your
current changes in a wide variety of version control systems,
including Git, Bazaar, Mercurial, Subversion and CVS.

%prep
%setup

%build
%python3_build

%install
%__python3 setup.py \
	--no-update-icon-cache \
	--no-compile-schemas \
	install \
	--root=%buildroot

%find_lang %name --with-gnome

%files -f %name.lang
%_bindir/%name
%python3_sitelibdir_noarch/*
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_iconsdir/hicolor/*/*/*
%_iconsdir/HighContrast/*/*/*
%_datadir/glib-2.0/schemas/org.gnome.meld.gschema.xml
%_datadir/mime/packages/%xdg_name.xml
%_datadir/metainfo/%xdg_name.appdata.xml
%_man1dir/%name.1.*
%doc NEWS

%changelog
