%def_enable seccomp
%def_enable extstore
%def_enable sasl
%def_enable tls

Name: memcached
Version: 1.6.9
Release: alt1

Summary: memcached - memory caching daemon
License: BSD
Group: System/Servers
Url: http://www.memcached.org/
#https://github.com/memcached/memcached.git
Source: %name-%version.tar
Patch: %name-%version.patch

%define pkg_user memcached
%define pkg_group memcached

BuildRequires: libevent-devel perl-devel perl-AnyEvent perl-YAML perl-Term-ReadKey perl-IO-Socket-SSL
%{?_enable_seccomp:BuildRequires: libseccomp-devel}
%{?_enable_sasl:BuildRequires: libsasl2-devel}
%{?_enable_tls:BuildRequires: libssl-devel >= 1.1.0}

%description
memcached is a flexible memory object caching daemon designed to  alle-
viate  database  load in dynamic web applications by storing objects in
specifically  optimized  to  avoid swapping and always use non-blocking
I/O.

%package devel
Summary: Files needed for development using memcached protocol
Group: Development/C
BuildArch: noarch
Requires: %name = %version-%release

%description devel
This package contains files needed for development using memcached
protocol.

%package tool
Summary: Stats and management tool for memcached
Group: Development/Tools
BuildArch: noarch

%description tool
memcached-tool is a Perl script used to print statistics from a running
memcached instance.

%prep
%setup
%patch -p1
sed -i 's,`git describe`,"%version-%release",g' version.pl

%build
perl version.pl
%autoreconf
%configure \
	%{subst_enable seccomp} \
	%{subst_enable extstore} \
	%{subst_enable sasl} \
	%{subst_enable tls}

%make_build

%install
%makeinstall_std
install -pD -m755 %name.init %buildroot%_initdir/%name
install -pD -m640 %name.sysconfig %buildroot%_sysconfdir/sysconfig/%name
install -pD -m644 %name.service %buildroot%_unitdir/%name.service
install -pD -m644 %{name}@.service %buildroot%_unitdir/%{name}@.service

# tool
install -pD -m755 scripts/memcached-tool %buildroot%_bindir/memcached-tool
install -pD -m644 scripts/memcached-tool.1 %buildroot%_man1dir/memcached-tool.1

%check
%make test ||:

%pre
%_sbindir/groupadd -r -f %pkg_group
%_sbindir/useradd -r -g %pkg_group -d /dev/null -s /dev/null -n %pkg_user \
	2> /dev/null > /dev/null ||:
if [ $1 -eq 2 ] && [ ! -f /var/run/%name/%name.pid ] && [ -f /var/run/%name.pid ]; then
   mkdir /var/run/%name/
   mv /var/run/%name.pid /var/run/%name/%name.pid
fi

%post
%post_service %name

%preun
%preun_service %name

%files
%config(noreplace) %attr(640,root,adm) %_sysconfdir/sysconfig/%name
%_bindir/%name
%_man1dir/%name.*
%_initdir/*
%_unitdir/*
%doc AUTHORS doc/CONTRIBUTORS ChangeLog NEWS README.md doc/*.txt

%files devel
%_includedir/*

%files tool
%_bindir/%name-tool
%_man1dir/%name-tool.*

%changelog
