Name: memtest86
Version: 4.0a
Release: alt4

Summary: Memory test for x86 architecture
License: GPL
Group: System/Kernel and hardware

Url: http://www.memtest86.com
Source0: %url/%name-%version.tar.gz
Source2: memtest86-3.0-README.rover
Source3: memtest86-3.0-rover-tested_cpus.tar.gz
Patch0: memtest86-3.0-rover-centrino+c3+amd.patch
Patch1: memtest86-3.2-rover-fixcrash.patch
Packager: Michael Shigorin <mike@altlinux.org>

ExclusiveArch: %ix86 x86_64
BuildRequires: dev86
Requires(post,preun): bootloader-utils >= 0.3

Summary(ru_RU.UTF-8): Тест памяти для x86-архитектуры
Summary(uk_UA.UTF-8): Тест пам'ят╕ для x86-арх╕тектури

%set_gcc_version 4.9

%description
Memtest86 is thorough, standalone memory test for x86 systems.

Memtest86 is a standalone program and can be loaded from either a disk
partition via lilo or a floppy disk. Memtest86 uses "moving inversions"
algorithm that is proven to be effective in finding memory errors.
The BIOS based memory test is just a quick check that will often miss
many of the failures that are detected by Memtest86.

%description -l ru_RU.UTF-8
Memtest86 -- тщательный и самостоятельный тест памяти для x86-систем.
Он может быть загружен или с жесткого диска при помощи LILO/GRUB,
или с дискеты.

Тест использует алгоритм "движущихся инверсий", доказавший свою
эффективность при обнаружении сбоев памяти. Не обращайте внимания
на "тест" BIOS -- он практически ничего не значит, так как
пропустит много ошибок из тех, которые обнаружит memtest86.

Также может использоваться для создания загрузочной тест-дискеты.

%description -l uk_UA.UTF-8
Memtest86 -- ретельний та самост╕йний тест пам'ят╕ для x86-систем.
В╕н може бути завантажений як з жорсткого диску за допомогою LILO/GRUB,
так ╕ з дискети.

Тест використову╓ алгоритм "рухаючихся ╕нверс╕й", який дов╕в свою
ефективн╕сть при визначенн╕ негаразд╕в ╕з пам'яттю. Не звертайте уваги
на "тест" BIOS -- в╕н практично н╕чого не означа╓, тому що пройде повз
багатьох збо╖в з тих, що знаходить memtest86.

Також може використовуватися для створення завантажувально╖
тест-дискети.

%prep
%setup
%patch1 -p1

%build
make	# intentionally without optimizations

%install
install -m644 -pD memtest.bin %buildroot/boot/memtest-%version.bin

%post
/sbin/installkernel --memtest %version

%preun
/sbin/installkernel --memtest --remove %version

%files
/boot/memtest-%version.bin
%doc README*

# TODO: consider building 4.3.7+ from sources extracted from
# https://www.memtest86.com/downloads/memtest86-4.3.7-iso.tar.gz

%changelog
