Name: menu-icons-default
Version: 0.2.0.20
Release: alt1

Group: Graphical desktop/Other
Summary: Icons for Menu system
License: GPL
URL: http://www.linux-mandrake.com
BuildArch: noarch

Requires: icon-theme-hicolor
Provides: menu-icons = %version-%release
Obsoletes: menu-icons-xpm, menu-icons-png, menu-icons-crystalmdk

# mandriva icons
Source1: menu-icons.tar
# viy low quality icons
Source0: menu-icons-extra.tar
Source2: oxygen.tar
Source3: scripts.tar

BuildRequires: ImageMagick

%description
Icons for menu system in png format from Mandrake Linux,
KDE Oxygen theme and specially made for ALTLinux.

%prep
%setup -c -a2 -a3

%install
mkdir -p %buildroot/%_iconsdir/hicolor/{16x16,22x22,32x32,36x36,48x48,64x64,scalable}/apps

# default mdk icons
pushd %buildroot/%_iconsdir/hicolor
    tar xf %SOURCE1
popd

# extra png icons
for f in 48x48/apps/*.png; do
	i=`basename $f`
	[ -e 32x32/apps/$i ] && install -m644 32x32/apps/$i %buildroot%_niconsdir/$i || convert -resize 32x32 $f %buildroot%_niconsdir/$i
	[ -e 16x16/apps/$i ] && install -m644 16x16/apps/$i %buildroot%_miconsdir/$i ||	convert -resize 16x16 $f %buildroot%_miconsdir/$i
	install -m644 $f %buildroot%_liconsdir/$i
	j=`echo $i | sed -e 's,.png$,,'`
	[ -e scalable/apps/$j.svg ] && install -m644 scalable/apps/$j.svg %buildroot%_iconsdir/hicolor/scalable/apps/$j.svg
done
install -m644 64x64/apps/*.png %buildroot%_iconsdir/hicolor/64x64/apps/

# map filtered oxygen icons
./scripts/map_oxygen.sh

%files
%_iconsdir/hicolor/*/apps/*.png
%_iconsdir/hicolor/scalable/apps/*

%changelog
