%def_disable snapshot

%define ver_major 0.55
%define libname mesonbuild
# pkexec may be used to "gain elevated privileges" during install
%def_without polkit
%def_disable check

Name: meson
Version: %ver_major.3
Release: alt2

Summary: High productivity build system
Group: Development/Python3
License: Apache-2.0
Url: http://mesonbuild.com/

%if_disabled snapshot
Source: https://github.com/mesonbuild/meson/archive/%version/%name-%version.tar.gz
%else
Source: %name-%version.tar
%endif

Source1: %name.macros
Source2: %name.env

BuildArch: noarch

%define python_ver 3.5.2
Requires: python3 >= %python_ver
Requires: ninja-build >= 1.7

#grep -n "from __main__" -r *
#mesonbuild/minstall.py:23:from __main__ import __file__ as main_file
%add_python3_req_skip __main__
%{?_with_polkit:Requires: polkit}

BuildRequires(pre): rpm-build-python3
BuildRequires: ninja-build python3-devel >= %python_ver python3-module-setuptools
%{?_with_polkit:BuildRequires: libpolkit-devel}
%if_enabled check
BuildRequires: gcc gcc-c++ gcc-fortran gcc-objc gcc-objc++
BuildRequires: java-devel /proc
BuildRequires: mono-core mono-devel
BuildRequires: boost-devel
BuildRequires: libgtest-devel
BuildRequires: libgmock-devel
BuildRequires: qt5-base-devel
BuildRequires: vala
BuildRequires: libwxGTK3.0-devel
BuildRequires: flex bison
BuildRequires: gnustep-base-devel
BuildRequires: git
BuildRequires: pkgconfig(protobuf) protobuf-c-compiler
BuildRequires: pkgconfig(gobject-introspection-1.0) python3-module-pygobject3 gtk-doc
BuildRequires: pkgconfig(zlib)
BuildRequires: python3-module-Cython
%endif

%description
Meson is a build system designed to optimize programmer productivity.
It aims to do this by providing simple, out-of-the-box support for modern
software development tools and practices, such as unit tests, coverage
reports, Valgrind, CCache and the like.

%prep
%setup

%build
%python3_build

%install
%python3_install
install -Dpm 0644 %SOURCE1 %buildroot%_rpmmacrosdir/%name
install -Dpm 0755 %SOURCE2 %buildroot%_rpmmacrosdir/%name.env

%check
export LC_ALL=en_US.utf8
MESON_PRINT_TEST_OUTPUT=1 ./run_tests.py

%files
%_bindir/%name
%python3_sitelibdir/%libname/
%python3_sitelibdir/%name-%ver_major.*-*.egg-info/
%{?_without_polkit:%exclude %_datadir/polkit-1/actions/com.mesonbuild.install.policy}
%_man1dir/%name.1.*
%_rpmmacrosdir/%name
%_rpmmacrosdir/%name.env
%doc COPYING README.*


%changelog
