Epoch: 0
Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java unzip
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           mockito
Version:        1.10.19
Release:        alt1_15jpp8
Summary:        A Java mocking framework

License:        MIT
URL:            http://%{name}.org
Source0:        %{name}-%{version}.tar.xz
Source1:        make-%{name}-sourcetarball.sh
Patch0:         fixup-ant-script.patch
Patch1:         fix-bnd-config.patch
Patch2:         %{name}-matcher.patch
# Workaround for NPE in setting NamingPolicy in cglib
Patch3:         setting-naming-policy.patch
# because we have old objenesis
Patch4:         fix-incompatible-types.patch

BuildArch:      noarch
BuildRequires:  javapackages-local
BuildRequires:  java-devel
BuildRequires:  ant
BuildRequires:  objenesis
BuildRequires:  cglib
BuildRequires:  junit
BuildRequires:  hamcrest
BuildRequires:  aqute-bnd

Requires:       objenesis
Requires:       cglib
Requires:       junit
Requires:       hamcrest
Source44: import.info

%description
Mockito is a mocking framework that tastes really good. It lets you write
beautiful tests with clean & simple API. Mockito doesn't give you hangover
because the tests are very readable and they produce clean verification
errors.

%package javadoc
Group: Development/Java
Summary:        Javadocs for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q
%patch0
%patch1
%patch2 -p1
%patch3 -p1
%patch4 -p1
# workaround rhbz#1292777 Files not found for javadoc generation
touch javadoc/stylesheet.css

%pom_add_dep net.sf.cglib:cglib:3.1 maven/mockito-core.pom
find . -name "*.java" -exec sed -i "s|org\.%{name}\.cglib|net\.sf\.cglib|g" {} +
mkdir -p lib/compile

%build
build-jar-repository lib/compile objenesis cglib junit hamcrest/core
ant jar javadoc

# Convert to OSGi bundle
pushd target
bnd wrap \
 --version %{version} \
 --output %{name}-core-%{version}.bar \
 --properties ../conf/%{name}-core.bnd \
 %{name}-core-%{version}.jar
mv %{name}-core-%{version}.bar %{name}-core-%{version}.jar

# Explicit Require-Bundle on hamcrest
unzip mockito-core-%{version}.jar META-INF/MANIFEST.MF
sed -i -e '2iRequire-Bundle: org.hamcrest.core' META-INF/MANIFEST.MF
jar umf META-INF/MANIFEST.MF mockito-core-%{version}.jar
popd

sed -i -e "s|@version@|%{version}|g" maven/%{name}-core.pom
%mvn_artifact maven/%{name}-core.pom target/%{name}-core-%{version}.jar
%mvn_alias org.%{name}:%{name}-core org.%{name}:%{name}-all

%install
%mvn_install -J target/javadoc

%files -f .mfiles
%doc --no-dereference LICENSE NOTICE

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE NOTICE

%changelog
