%define docver 3.40

Summary: Painting program for creating icons and pixel-based artwork
Name: mtpaint
Version: 3.40
Release: alt2.1
License: GPLv3+
Group: Graphics
Url: http://mtpaint.sourceforge.net/
Source: %name-%version.tar.bz2
Source1: http://downloads.sf.net/%name/%{name}_handbook-%docver.zip
Patch: %name-3.40-xdg-open.patch
Patch1: %name-3.40-openjpeg.patch

BuildRequires: gtk2-devel zlib-devel unzip
BuildRequires: libpng-devel libungif-devel libjpeg-devel libtiff-devel
BuildRequires: desktop-file-utils gettext dos2unix

Requires: %name-handbook

%description
mtPaint is a simple painting program designed for creating icons and
pixel-based artwork. It can edit indexed palette or 24 bit RGB images
and offers basic painting and palette manipulation tools. Its main
file format is PNG, although it can also handle JPEG, GIF, TIFF, BMP,
XPM, and XBM files.

%package handbook
Summary: Handbook for the mtpaint painting application
Group: Graphics
License: GFDL
Buildarch: noarch
Requires: %name = %version-%release

%description handbook
Install this package is want to read the handbook for the painting
application mtpaint.

%prep
%setup -a 1
%patch -p1
%patch1 -p1

# We have moved docs
sed -i 's,#define HANDBOOK_LOCATION "/usr/doc/mtpaint/index.html",#define HANDBOOK_LOCATION "%_docdir/%name-handbook-%version/index.html",' src/spawn.c

chmod 0755 %{name}_handbook-%docver/docs/{en_GB,img,files,cs}
dos2unix -k %{name}_handbook-%docver/docs/index.html
dos2unix -k %{name}_handbook-%docver/docs/{en_GB,cs}/*.html

%build
# This is not a "normal" configure
./configure --datarootdir=%_datadir \
	cflags asneeded debug intl man gtk2 tiff jpeg GIF
%make_build

%install
rm -rf %buildroot
%makeinstall MT_PREFIX=%buildroot%prefix            \
                  MT_MAN_DEST=%buildroot%_mandir     \
		  MT_DATAROOT=%buildroot%_datadir \
                  MT_LANG_DEST=%buildroot%_datadir/locale \
                  BIN_INSTALL=%buildroot%_bindir

desktop-file-install --delete-original         \
    --vendor "" \
    --dir %buildroot%_datadir/applications \
    %buildroot%_datadir/applications/%name.desktop
%find_lang %name

%files -f %name.lang
%doc COPYING NEWS README
%_mandir/man1/%{name}*
%_bindir/%name
%_datadir/applications/*.desktop
%_datadir/pixmaps/%name.png

%files handbook
%doc %{name}_handbook-%docver/COPYING %{name}_handbook-%docver/docs/*

%changelog
