%define basedir %_datadir/%name
%define xdgdir  %_xdgconfigdir/autostart

Name:     myconnector
Version:  2.3
Release:  alt1

Summary:  MyConnector - remote desktop client
License:  GPL-2.0
Group:    Networking/Remote access

Url:      http://myconnector.ru
Source0:  %name-%version.tar.gz
Packager: Evgeniy Korneechev <ekorneechev@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-xdg

Requires: control
Requires: libgtk+3
Requires: libgtk+3-gir
Requires: python3-module-pygobject3
Requires: python3-module-keyring >= 12.0.0
Requires: python3-module-secretstorage
Requires: remmina
Requires: remmina-plugins
Requires: tigervnc
Requires: xdg-utils
Requires: xfreerdp
Requires: zenity

Provides:  connector = %EVR
Obsoletes: connector

BuildArch: noarch

%description
This is an aggregator program to connect to various servers
using all of the popular remote desktop protocols
(RDP, VNC, Citrix, VMware, etc).

%package kiosk
Summary: Mode "KIOSK" for MyConnector
Group:   Networking/Remote access

Requires: myconnector = %EVR
Requires: xinitrc
Requires: xterm

Provides:  connector-kiosk = %EVR
Obsoletes: connector-kiosk

%description kiosk
Files for connector mode "KIOSK"

%package autostart
Summary: Autostart connector within desktop session
Group:   Networking/Remote access

Requires: myconnector = %EVR

Provides:  connector-autostart = %EVR
Obsoletes: connector-autostart

%description autostart
#thanks mike@
Autostart MyConnector within desktop session

%package docs
Summary: Documentation for MyConnector
Group:   Documentation

%description docs
This package contains MyConnector docs (in Russian) in reStructuredText and HTML formats.

%prep
%setup

%install
install -pDm755 bin/%name %buildroot%_bindir/%name
ln -s %name %buildroot%_bindir/connector
mkdir -p %buildroot%python3_sitelibdir/%name
cp -av lib/*.py %buildroot%python3_sitelibdir/%name
cp -r share %buildroot%_usr/
install -pm755 bin/%name-check-* %buildroot%basedir
install -pm755 bin/ctor2myc %buildroot%_bindir/ctor2myc
mkdir -p %buildroot%basedir/kiosk/
install -pm644 kiosk/kiosk.py %buildroot%python3_sitelibdir/%name
install -pm644 kiosk/kiosk.ui %buildroot%basedir/ui
install -pm755 kiosk/myconnector-*kiosk %buildroot%basedir/kiosk
install -pm755 kiosk/myconnector-kiosk-check %buildroot%basedir/kiosk
install -pm755 kiosk/*.desktop %buildroot%basedir/kiosk
install -pDm600 kiosk/kiosk.conf %buildroot%_sysconfdir/%name/kiosk.conf
install -pDm644 myconnector.conf %buildroot%_sysconfdir/%name/%name.conf
install -pDm644 %name.bashcomp %buildroot%_datadir/bash-completion/completions/%name
mkdir -p %buildroot%xdgdir
cat > %buildroot%xdgdir/myconnector.desktop << EOF
[Desktop Entry]
Type=Application
Name=MyConnector
Exec=/usr/bin/myconnector
EOF
mkdir -p %buildroot%_datadir/locale/ru/LC_MESSAGES
msgfmt ru.po -o %buildroot%_datadir/locale/ru/LC_MESSAGES/%name.mo
%find_lang --with-man %name
%find_lang --with-man %name-kiosk

%files -f %name.lang
%_bindir/*
%python3_sitelibdir/%name
%exclude %python3_sitelibdir/%name/kiosk.py
%exclude %python3_sitelibdir/%name/__pycache__/kiosk.*
%_desktopdir/%name.desktop
%dir %basedir
%basedir/ui
%exclude %basedir/ui/kiosk.ui
%basedir/icons
%basedir/%name-check-*
%_man1dir/%name.*
%_datadir/mime/packages/%name.xml
%_iconsdir/hicolor/*/apps/%name.png
%_datadir/bash-completion/completions/%name
%config(noreplace) %_sysconfdir/%name/%name.conf

%files kiosk -f %name-kiosk.lang
%basedir/kiosk
%basedir/ui/kiosk.ui
%python3_sitelibdir/%name/kiosk.py
%python3_sitelibdir/%name/__pycache__/kiosk.*
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/kiosk.conf
%_man1dir/%name-kiosk.*

%files autostart
%xdgdir/myconnector.desktop

%files docs
%doc docs/*

%changelog
