%define _unpackaged_files_terminate_build 1

%def_disable debug
%def_enable syslog
%def_enable lfs
%def_disable sdp
%def_enable gznbd
%def_with setproctitle
%def_without  static_client

Name: nbd
Version: 3.20
Release: alt1
Summary: Network Block Device user space tools
License: GPL
Group: Networking/Other
URL: http://%name.sourceforge.net/

# https://github.com/NetworkBlockDevice/nbd.git
Source: %name-%version.tar

Source1: nbd.init
Source2: nbd-server.conf
Source3: nbd.service
Source4: nbd.sysconfig

Patch1: %name-alt.patch

BuildRequires: glib2-devel docbook-utils
%{?_with_setproctitle:BuildRequires: setproctitle-devel}
%{?_enable_gznbd:BuildRequires: zlib-devel}
%{?_with_static_client:BuildRequires: dietlibc}
%{?_enable_sdp:BuildRequires: libsdp-devel}

%description
Tools for the Linux Kernel's network block device, allowing you to use
remote block devices over a TCP/IP network.

%package doc
Summary: Network Block Device user space tools documentation
Group: Documentation
BuildArch: noarch

%description doc
This package contains basic documentation for Network Block Device
user space tools.

%package server
Summary: Network Block Device server
Group: Networking/Other
Requires: %name-doc = %EVR

%description server
This package contains nbd-server - a user space daemon to serve files
for Network Block Devices on remote hosts.

%package client
Summary: Network Block Device client
Group: Networking/Other
Requires: %name-doc = %EVR

%description client
This package contains nbd-client - a user space tool needed to manage
a Network Block Device.

%if_with static_client
%package client-static
Summary: Network Block Device static client
Group: Networking/Other
Requires: %name-doc = %EVR

%description client-static
This package contains a statically linked edition of nbd-client.
%endif

%prep
%setup
%patch1 -p1

%build
./autogen.sh

%if_with static_client
%configure \
    %{subst_enable debug} \
    %{subst_enable lfs} \
    --disable-syslog \
    --disable-sdp \
    %nil

make CC="diet -Os %__cc" CFLAGS="%optflags -Os" LDADD="-lcompat" %name-client
mv %name-client{,.static}
%make_build clean
%endif

%configure \
    %{subst_enable debug} \
    %{subst_enable lfs} \
    %{subst_enable syslog} \
    %{subst_enable sdp} \
    %{subst_with setproctitle} \
    %{subst_enable gznbd} \
    %nil

%make_build

%install
%makeinstall_std
%{?_with_static_client:install -pm755 %name-client.static %buildroot%_sbindir/}
install -pD -m755 %SOURCE1 %buildroot%_initdir/%name
install -pD -m755 %SOURCE3 %buildroot%_unitdir/nbd.service
install -pD -m644 %SOURCE4 %buildroot%_sysconfdir/sysconfig/nbd-server
install -pD %SOURCE2 %buildroot%_sysconfdir/%name-server/config

%define docdir %_docdir/%name-%version
mkdir -p %buildroot%docdir
install -pm644 README.md tests/run/simple_test %buildroot%docdir/

%pre server
%_sbindir/groupadd -r -f _nbd
%_sbindir/useradd -r -g _nbd -d /dev/null -s /dev/null -n _nbd > /dev/null 2>&1 ||:

%post server
%post_service %name

%preun server
%preun_service %name

%files doc
%docdir

%files server
%_bindir/*
%config(noreplace) %_sysconfdir/sysconfig/nbd-server
%_man1dir/*
%_man5dir/*
%_initdir/*
%_unitdir/*.service
%defattr(600,root,_nbd,710)
%config(noreplace) %_sysconfdir/%name-server/

%files client
%_sbindir/%name-client
%_man8dir/*

%if_with static_client
%files client-static
%_sbindir/%name-client.static
%endif

%changelog
