%define _unpackaged_files_terminate_build 1

Name: ncmpc
Version: 0.31
Release: alt1
Summary: curses client for mpd
License: GPL
Group: Sound
Url: https://www.musicpd.org/

# https://github.com/MusicPlayerDaemon/ncmpc.git
Source: %name-%version.tar
Source1: %name.desktop

BuildRequires(pre): meson
BuildRequires: gcc-c++
BuildRequires: glib2-devel libncursesw-devel libtinfo-devel pkg-config
BuildRequires: liblirc-devel
BuildRequires: libmpdclient-devel
BuildRequires: desktop-file-utils
BuildRequires: doxygen
BuildRequires: python3-module-sphinx

%description
ncmpc is a curses client for the Music Player Daemon (MPD). ncmpc
connects to a MPD running on a machine on the local network, and
controls this with an interface inspired by cplay. If ncmpc is used
with lirc and irpty it can be used to manage playlists and control MPD
with a remote control.

%prep
%setup
sed -i -e "s,sphinx-build,sphinx-build-3,g" doc/meson.build

%build
%meson \
	-D lirc=true \
	-D lyrics_screen=true \
	-D lyrics_plugin_dir=%_datadir/%name/lyrics

%meson_build

%install
%meson_install

install -m 644 -D %SOURCE1 %buildroot%_desktopdir/%name.desktop
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=AudioVideo \
	--add-category=Player \
	%buildroot%_desktopdir/%name.desktop

rm -f %buildroot%_defaultdocdir/%name/html/.buildinfo

%find_lang %name

%check
%meson_test

%files -f %name.lang
%_bindir/*
%_man1dir/*
%_desktopdir/%name.desktop
%_defaultdocdir/%name
%_datadir/%name

%changelog
