Name: nextcloud-client
Version: 2.6.4
Release: alt3

Group: Networking/File transfer
Summary: Nextcloud Desktop Client
License: GPLv2
Url: https://github.com/nextcloud/desktop


Provides: mirall = %version-%release
Obsoletes: mirall <= %version-%release

Provides: nextcloud-desktop = %version-%release

Source0: %name-%version.tar
Source2: nextcloud-client.desktop
Patch1: alt-dont-check-updates.patch
Patch2: alt-confdir.patch
Patch3: alt-static-libs.patch
Patch4: %name-2.3.3-alt-fix-help-url.patch
Patch5: alt-move-deleted-to-trash.patch
Patch6: alt-qt5.15.patch

BuildRequires: kde-common-devel rpm-build-kf5
BuildRequires: doxygen extra-cmake-modules graphviz kf5-kio-devel libqtkeychain-qt5-devel libsqlite3-devel libssl-devel python3-dev qt5-tools-devel zlib-devel
BuildRequires: qt5-webengine-devel libgio-devel glib2-devel qt5-svg-devel
BuildRequires: kf5-kwindowsystem-devel

%description
The Nextcloud Desktop Client is a tool to synchronize files from Nextcloud Server with your computer.

%package kde5
Summary: KDE5 %name integration
Group: Graphical desktop/KDE
Requires: %name
%description kde5
KDE5 %name integration

%prep
%setup
%patch6 -p1

%build
%add_optflags %optflags_shared
%Kbuild \
    -DBUILD_WITH_QT4=OFF \
    -DDATA_INSTALL_DIR=%_datadir \
    -DCMAKE_INSTALL_SYSCONFDIR=/etc/%name \
    -DKDE_INSTALL_PLUGINDIR=%_K5plug \
    -DKDE_INSTALL_KSERVICES5DIR=%_K5srv \
    -DCMAKE_BUILD_TYPE=Release \
    -DNO_SHIBBOLETH=1

%install
%Kinstall
mkdir -p %buildroot/%_desktopdir
desktop-file-install \
    --dir=%buildroot/%_desktopdir %SOURCE2
cd %buildroot/%_libdir
ln -s nextcloud/libocsync.so.%version libocsync.so.0; cd ../..
%find_lang --with-qt --output=%name.lang client

%files -f %buildroot/%name.lang
%doc README.md
%dir %_datadir/nextcloud
%dir %_datadir/nextcloud/i18n
%dir %_sysconfdir/Nextcloud
%dir %_libdir/nextcloud
%config(noreplace) %_sysconfdir/Nextcloud/sync-exclude.lst
%_bindir/nextcloud
%_bindir/nextcloudcmd
%_libdir/lib*sync.*
%_libdir/nextcloud/*
%_desktopdir/%name.desktop
%_datadir/nautilus-python/extensions/
%_datadir/caja-python/extensions/
%_iconsdir/hicolor/*/apps/Nextcloud.*
%_iconsdir/hicolor/*/apps/Nextcloud_*.*

%files kde5
%_K5lib/libnextclouddolphinpluginhelper.so
%_K5plug/kf5/overlayicon/
%_K5plug/*nextcloud*.so
%_K5srv/*nextcloud*.desktop

%changelog
