%def_enable shared
%def_enable static
%def_with selinux
%def_with blkid
%def_with libmount
%define libdir /%_lib

%define bname nilfs
%define lname lib%bname

Name: %bname-utils
Version: 2.2.7
Release: alt1

Summary: Utilities for managing NILFS v2 filesystems
License: GPLv2+
Group: System/Kernel and hardware

Url: http://www.%bname.org
Source: http://www.%bname.org/download/%name-%version.tar
Patch: %name-%version-%release.patch

Provides: %{bname}2-utils = %version-%release
%{!?_disable_shared:Requires: %lname = %version-%release}

BuildRequires: libuuid-devel
%{?_with_blkid:BuildRequires: libblkid-devel}
%{?_with_libmount:BuildRequires: libmount-devel}
%{?_with_selinux:BuildRequires: libselinux-devel}

%description
Utilities to work with NILFS v2 filesystems.

%if_enabled shared
%package -n %lname
Summary: NILFS v2 libraries
Group: System/Libraries
License: LGPLv2

%description -n %lname
This package contains shared code for %name and other utilities dealing
with NILFS v2 filesystems.
%endif

%package -n %lname-devel
Summary: NILFS v2 filesystem-specific headers
Group: Development/C
Requires: %lname%{?_disable_shared:-devel-static} = %version-%release
License: LGPLv2

%description -n %lname-devel
This package contains the header files needed to develop NILFS v2
filesystem-specific programs.

%if_enabled static
%package -n %lname-devel-static
Summary: NILFS v2 static libraries
Group: Development/C
Requires: %lname-devel = %version-%release
License: LGPLv2+

%description -n %lname-devel-static
This package contains NILFS v2 static libraries.
%endif

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--libdir=%libdir \
	--sbindir=/sbin \
	--enable-largefile \
	%{subst_enable static} \
	%{subst_with blkid} \
	%{subst_with libmount} \
	%{subst_with selinux} \
	--with-gnu-ld
%make_build
gzip -9c ChangeLog > ChangeLog.gz

%install
%makeinstall_std
%if "%libdir" != "%_libdir"
install -dm755 %buildroot%_libdir
%if_enabled shared
for f in %buildroot%libdir/*.so; do
	ln -sf %libdir/$(readlink $f) %buildroot%_libdir/$(basename $f)
	rm -f $f
done
%endif
%{?_enable_static:mv %buildroot%libdir/*.a %buildroot%_libdir/}
%endif

%files
%doc AUTHORS ChangeLog.*
%config(noreplace) %_sysconfdir/%{bname}_cleanerd.conf
/sbin/*
%_sbindir/*
%_bindir/*
%_man1dir/*
%_man5dir/*
%_man8dir/*

%if_enabled shared
%files -n %lname
%libdir/*.so.*
%endif

%files -n %lname-devel
%{?_enable_shared:%_libdir/*.so}
%_includedir/*

%if_enabled static
%files -n %lname-devel-static
%_libdir/*.a
%endif

%changelog
