%define _unpackaged_files_terminate_build 1

Name:           nuget
Version:        2.8.7
Release:        alt1
Summary:        Package manager for .Net/Mono development platform
Group:          Development/Other
License:        Apache-2.0
Url:            http://nuget.org/

# http://download.mono-project.com/sources/%name/%name_%{version}+md510+dhx1.orig.tar.bz2
Source0:        %name-%version.tar
Source1:        nuget-core.pc
Source2:        nuget.sh
Patch0:         nuget-fix_xdt_hintpath.patch

BuildRequires(pre): rpm-build-mono
BuildRequires: mono-devel mono-winfx

%description
NuGet is the package manager for the Microsoft
development platform including .NET. The NuGet client
tools provide the ability to produce and consume
packages. The NuGet Gallery is the central package
repository used by all package authors and consumers.

%package        devel
Summary:        Development files for %name
Group:          Development/Other
Requires:       %name = %EVR

%description devel
Development package for %name

%prep
%setup
sed -i "s/\r//g" src/Core/Core.csproj
%patch0 -p1

# fix compile with Mono4
find . -name "*.sln" -print -exec sed -i 's/Format Version 10.00/Format Version 11.00/g' {} \;
find . -name "*.csproj" -print -exec sed -i 's#ToolsVersion="3.5"#ToolsVersion="4.0"#g; s#<TargetFrameworkVersion>.*</TargetFrameworkVersion>##g; s#<PropertyGroup>#<PropertyGroup><TargetFrameworkVersion>v4.5</TargetFrameworkVersion>#g' {} \;

%build
xbuild xdt/XmlTransform/Microsoft.Web.XmlTransform.csproj
xbuild src/Core/Core.csproj /p:Configuration="Mono Release"
xbuild src/CommandLine/CommandLine.csproj /p:Configuration="Mono Release"

%install
mkdir -p %buildroot%_monodir/nuget
mkdir -p %buildroot%_libdir/pkgconfig
mkdir -p %buildroot%_bindir
install -m0644 %{SOURCE1} %buildroot%_pkgconfigdir/
install -m0755 %{SOURCE2} %buildroot%_bindir/$(basename -s .sh %{SOURCE2})
sed -i -e 's/cli/mono/' %buildroot%_bindir/*
install -m0755 src/CommandLine/bin/Release/NuGet.Core.dll %buildroot%_monodir/nuget/
install -m0755 xdt/XmlTransform/bin/Debug/Microsoft.Web.XmlTransform.dll %buildroot%_monodir/nuget/
install -m0755 src/CommandLine/bin/Release/NuGet.exe %buildroot%_monodir/nuget/

%files
%doc LICENSE.txt COPYRIGHT.txt
%doc acknowledgements.md changelog.md CREDITS.txt
%_monodir/nuget
%_bindir/*

%files devel
%_pkgconfigdir/nuget-core.pc

%changelog
