%set_verify_elf_method textrel=relaxed

%define tbname         NVIDIA-Linux-x86_64
%ifarch aarch64
%define tbname         NVIDIA-Linux-aarch64
%endif
%define dirsuffix %nil

%define nvidia_sover 1
%define nvvm_sover 4

%ifarch %ix86
%define subd ./32
%else
%define subd ./
%endif

%define nv_version 550
%define nv_release 67
%define nv_minor   %nil
%define pkg_rel alt1
%define nv_version_full %{nv_version}.%{nv_release}.%{nv_minor}
%if "%nv_minor" == "%nil"
%define nv_version_full %{nv_version}.%{nv_release}
%endif
Name: nvidia_glx_libs_%nv_version_full
Version: %nv_version_full
Release: %pkg_rel

ExclusiveArch: %ix86 x86_64 aarch64

Source0: null
Source201: http://http.download.nvidia.com/XFree86/Linux-x86_64/%version/%tbname-%version.run
Source202: http://http.download.nvidia.com/XFree86/Linux-x86_64/%version/%tbname-%version.run

BuildRequires: rpm-macros-alternatives
BuildRequires: libXext-devel libEGL-devel
BuildRequires: libwayland-client-devel libwayland-server-devel
#BuildRequires: libGLdispatch libGLX

Group: System/Kernel and hardware
Summary: NVIDIA drivers and OpenGL libraries for XOrg X-server
Summary(ru_RU.UTF-8): Драйверы NVIDIA и библиотеки OpenGL для Х-сервера XOrg
Url: http://www.nvidia.com
License: NVIDIA
%description
Sources for nvidia_glx package

%package -n ocl-nvidia
Group: System/Libraries
#BuildArch: noarch
Summary: nvidia library
Requires: libnvidia-opencl
Requires: libnvidia-ptxjitcompiler
Requires: libnvidia-ml
%description -n ocl-nvidia
nvidia OpenCL library

%package -n libnvidia-ptxjitcompiler
Group: System/Libraries
Summary: nvidia library
Provides: libnvidia-ptxjitcompiler = %version-%release
%description -n libnvidia-ptxjitcompiler
nvidia library

%package -n libnvidia-ml
Group: System/Libraries
Summary: nvidia library
Provides: libnvidia-ml = %version-%release
%description -n libnvidia-ml
nvidia library

%package -n libcuda
Group: System/Libraries
Summary: nvidia library
Provides: libnvidia-cuda = %EVR
Obsoletes: libnvidia-cuda < %EVR
%description -n libcuda
nvidia CUDA library

%package -n libcudadebugger
Group: System/Libraries
Summary: nvidia library
Provides: libnvidia-cuda = %EVR
Obsoletes: libnvidia-cuda < %EVR
%description -n libcudadebugger
nvidia CUDA debugger library

%package -n libnvidia-opencl
Group: System/Libraries
Summary: nvidia library
Requires: ocl-icd
Requires: libnvidia-nvvm
%description -n libnvidia-opencl
nvidia OpenCL library

%package -n libnvcuvid
Group: System/Libraries
Summary: nvidia library
Provides: libnvidia-nvcuvid = %version-%release
%description -n libnvcuvid
nvidia library

%package -n libnvoptix
Group: System/Libraries
Summary: nvidia library
Provides: libnvidia-nvcuvid = %version-%release
%description -n libnvoptix
nvidia library

%package -n libnvidia-encode
Group: System/Libraries
Summary: nvidia library
%description -n libnvidia-encode
nvidia library

%package -n libnvidia-nvvm
Group: System/Libraries
Summary: nvidia library
%description -n libnvidia-nvvm
nvidia library

%package -n libnvidia-ngx
Group: System/Libraries
Summary: nvidia library
%description -n libnvidia-ngx
nvidia library

%package -n libnvidia-fbc
Group: System/Libraries
Summary: nvidia library
%description -n libnvidia-fbc
nvidia library

%package -n libnvidia-api
Group: System/Libraries
Summary: nvidia library
%description -n libnvidia-api
nvidia library

%package -n nvidia-smi
Group: System/Libraries
Summary: NVIDIA System Management Interface program
%description -n nvidia-smi
nvidia-smi (also NVSMI) provides monitoring and management capabilities for each of
NVIDIA's Tesla, Quadro, GRID and GeForce devices from Fermi and higher architecture families.

%package -n nvidia-wine
Group: System/Libraries
Summary: NVIDIA DLLs for wine
Requires: nvidia_glx_common
%description -n nvidia-wine
NVIDIA DLLs for wine.

%prep
%setup -T -c -n %tbname-%version%dirsuffix
rm -rf %_builddir/%tbname-%version%dirsuffix
cd %_builddir
%ifarch aarch64
sh %SOURCE202 -x
%else
sh %SOURCE201 -x
%endif
cd %tbname-%version%dirsuffix

pushd kernel
rm -rf precompiled
popd

%build
%install
# install libraries
mkdir -p %buildroot/%_libdir/
install -m 0644 %subd/libcuda.so.%version %buildroot/%_libdir/
install -m 0644 %subd/libnvidia-opencl.so.%version %buildroot/%_libdir/
install -m 0644 %subd/libnvidia-ptxjitcompiler.so.%version %buildroot/%_libdir/
install -m 0644 %subd/libnvidia-ml.so.%version %buildroot/%_libdir/
install -m 0644 %subd/libnvcuvid.so.%version %buildroot/%_libdir/
install -m 0644 %subd/libnvidia-encode.so.%version %buildroot/%_libdir/
install -m 0644 %subd/libnvidia-nvvm.so.%version %buildroot/%_libdir/
install -m 0644 %subd/libnvidia-fbc.so.%version %buildroot/%_libdir/
%if "%_lib" != "lib"
install -m 0644 %subd/libnvoptix.so.%version %buildroot/%_libdir/
install -m 0644 %subd/libnvidia-ngx.so.%version %buildroot/%_libdir/
install -m 0644 %subd/libcudadebugger.so.%version %buildroot/%_libdir/
install -m 0644 %subd/libnvidia-api.so.%nvidia_sover %buildroot/%_libdir/libnvidia-api.so.%version
# install data
mkdir -p %buildroot/%_datadir/nvidia/
install -m 0644 %subd/nvoptix.bin %buildroot/%_datadir/nvidia/
# install programs
mkdir -p %buildroot/%_bindir/
install -m 0755 nvidia-smi %buildroot/%_bindir/
mkdir -p %buildroot/%_man1dir/
install -m 0644 nvidia-smi.1.gz %buildroot/%_man1dir/
%endif
# install dlls
%ifarch x86_64
#mkdir -p %buildroot/%_libdir/nvidia/wine/
#install -m 0755 *nvngx.dll %buildroot/%_libdir/nvidia/wine/
%endif
mkdir -p %buildroot/%_sysconfdir/OpenCL/vendors/
install -m 0644 nvidia.icd %buildroot/%_sysconfdir/OpenCL/vendors/
# fixing the work of CUDA rendering in DaVinci Resolve without nvidia-cuda-toolkit and more
for l in libcuda libnvcuvid libnvidia-encode libnvidia-ml ; do
    ln -s ${l}.so.%version %buildroot/%_libdir/${l}.so
done

%files -n ocl-nvidia
%files -n libnvidia-ptxjitcompiler
%_libdir/libnvidia-ptxjitcompiler.so.%version
%_libdir/libnvidia-ptxjitcompiler.so.%nvidia_sover
%files -n libnvidia-ml
%_libdir/libnvidia-ml.so.%version
%_libdir/libnvidia-ml.so.%nvidia_sover
%_libdir/libnvidia-ml.so
%files -n libcuda
%_libdir/libcuda.so.%nvidia_sover
%_libdir/libcuda.so.%version
%_libdir/libcuda.so
%files -n libnvidia-opencl
%_libdir/libnvidia-opencl.so.%nvidia_sover
%_libdir/libnvidia-opencl.so.%version
%_sysconfdir/OpenCL/vendors/nvidia.icd
%files -n libnvcuvid
%_libdir/libnvcuvid.so.%nvidia_sover
%_libdir/libnvcuvid.so.%version
%_libdir/libnvcuvid.so
%files -n libnvidia-encode
%_libdir/libnvidia-encode.so.%nvidia_sover
%_libdir/libnvidia-encode.so.%version
%_libdir/libnvidia-encode.so
%files -n libnvidia-nvvm
%_libdir/libnvidia-nvvm.so.%nvvm_sover
%_libdir/libnvidia-nvvm.so.%version
%files -n libnvidia-fbc
%_libdir/libnvidia-fbc.so.%nvidia_sover
%_libdir/libnvidia-fbc.so.%version
%if "%_lib" != "lib"
%files -n nvidia-smi
%_bindir/nvidia-smi
%_man1dir/nvidia-smi.1.*
%ifarch x86_64
#%files -n nvidia-wine
#%_libdir/nvidia/wine/
%endif
%files -n libnvidia-ngx
%_libdir/libnvidia-ngx.so.%nvidia_sover
%_libdir/libnvidia-ngx.so.%version
%files -n libnvoptix
%_libdir/libnvoptix.so.%nvidia_sover
%_libdir/libnvoptix.so.%version
%_datadir/nvidia/nvoptix.bin
%files -n libcudadebugger
%_libdir/libcudadebugger.so.%nvidia_sover
%_libdir/libcudadebugger.so.%version
%files -n libnvidia-api
%_libdir/libnvidia-api.so.%nvidia_sover
%_libdir/libnvidia-api.so.%version
%endif

%changelog
