Summary: Tools for managing the Oracle Cluster Filesystem 2
Name: ocfs2-tools
Version: 1.8.5
Release: alt3.0378c47
License: GPL
Group: System/Kernel and hardware
# https://github.com/markfasheh/ocfs2-tools
Source: %name-%version.tar
Source1: cluster.conf

Patch0: ocfs2-tools-initscript.patch
Patch1: ocfs2-tools-service.patch

Url: http://oss.oracle.com/projects/ocfs2-tools/
BuildRequires: e2fsprogs-devel, glib2-devel, python-module-pygtk , python-devel, readline-devel, ncurses-devel, libe2fs-devel, libuuid-devel, libaio-devel

%description
Tools to manage Oracle Cluster Filesystem 2 volumes.

%package -n ocfs2console
Summary: GUI frontend for OCFS2 management
Group: System/Kernel and hardware
Requires: ocfs2-tools = %version
%py_provides o2cb ocfs2 plist

%description -n ocfs2console
GUI frontend for management and debugging of Oracle Cluster Filesystem 2
volumes.

%package -n ocfs2-tools-devel
Summary: Headers and static archives for ocfs2-tools
Group: Development/Other
Requires: ocfs2-tools = %version

%description -n ocfs2-tools-devel
ocfs2-tools-devel contains the libraries and header files needed to
develop ocfs2 filesystem-specific programs.

%prep
%setup
%patch0 -p1
%patch1 -p1

%build
%autoreconf
%configure --enable-dynamic-ctl=yes --enable-ocfs2console=yes --enable-dynamic-fsck=yes --disable-debug --prefix=/usr --mandir=%_datadir/man --libdir=%_libdir
make

%install
mkdir -p %buildroot%_sysconfdir/sysconfig %buildroot%_initdir
install -m755 vendor/common/o2cb.init %buildroot%_initdir/o2cb
install -m755 vendor/common/ocfs2.init %buildroot%_initdir/ocfs2
install -pDm644 vendor/common/o2cb.service %buildroot%_unitdir/o2cb.service
install -pDm644 vendor/common/ocfs2.service %buildroot%_unitdir/ocfs2.service
install -m644 vendor/common/o2cb.sysconfig %buildroot%_sysconfdir/sysconfig/o2cb
mkdir -p %buildroot/var/run/o2cb

mkdir -p %buildroot/%_sysconfdir/ocfs2/
install -m600 %SOURCE1 %buildroot/%_sysconfdir/ocfs2/

make DESTDIR="%buildroot" install

%__python -c "import compileall; compileall.compile_dir('%buildroot/%python_sitelibdir/ocfs2interface', ddir='%_libdir/%python_sitelibdir/ocfs2interface')"

%post
%post_service o2cb
%post_service ocfs2

%preun
%preun_service ocfs2
%preun_service o2cb

%files
%doc README.O2CB COPYING CREDITS MAINTAINERS
%doc documentation/users_guide.txt
/sbin/*
%_initdir/*
%_unitdir/*.service
%config(noreplace) %_sysconfdir/sysconfig/o2cb
%config(noreplace) %_sysconfdir/ocfs2/cluster.conf
%_sbindir/o2hbmonitor
%_bindir/o2info
%_man5dir/o2cb.sysconfig.5.*
%_man5dir/ocfs2.cluster.conf.5*
%_man7dir/o2cb.7*
%_man7dir/ocfs2.7*
%_man8dir/debugfs.ocfs2.8*
%_man8dir/fsck.ocfs2.8*
%_man8dir/fsck.ocfs2.checks.8*
%_man8dir/mkfs.ocfs2.8*
%_man8dir/tunefs.ocfs2.8*
%_man8dir/mount.ocfs2.8*
%_man8dir/mounted.ocfs2.8*
%_man8dir/o2cb_ctl.8*
%_man8dir/o2cb.8*
%_man8dir/o2image.8*
%_man8dir/o2cluster.8*
%_man8dir/o2hbmonitor.8*
%_man8dir/ocfs2_hb_ctl.8*
%_man1dir/o2info.1*
%dir /var/run/o2cb

%files -n ocfs2console
%_libdir/python%__python_version/site-packages/ocfs2interface
%_sbindir/ocfs2console
%_man8dir/ocfs2console.8*

%files -n ocfs2-tools-devel
%_libdir/*.a
%_libdir/pkgconfig/*.pc
%dir %_includedir/o2cb
%_includedir/o2cb/*.h
%dir %_includedir/o2dlm
%_includedir/o2dlm/*.h
%dir %_includedir/ocfs2
%_includedir/ocfs2/*.h
%dir %_includedir/ocfs2-kernel
%_includedir/ocfs2-kernel/*.h

%changelog
