Name: odfpy
Version: 1.3.6
Release: alt1
Summary: Python scripts for manipulating OpenDocument files

Group: Development/Python
License: GPLv2+
Url: https://joinup.ec.europa.eu/software/odfpy/home

# Source-url: https://pypi.io/packages/source/o/%name/%name-%version.tar.gz
Source: %name-%version.tar.gz

%setup_python_module %name

BuildArch: noarch

# Automatically added by buildreq on Tue Feb 02 2010
BuildRequires: python-devel python-module-setuptools
BuildRequires: python3-devel python3-module-setuptools

%description
    csv2odf - Create OpenDocument spreadsheet from comma separated values
    mailodf - Email ODF file as HTML archive
    odf2xhtml - Convert ODF to (X)HTML
    odf2mht - Convert ODF to HTML archive
    odf2xml - Create OpenDocument XML file from OD? package
    odfimgimport - Import external images
    odflint - Check ODF file for problems
    odfmeta - List or change the metadata of an ODF file
    odfoutline - Show outline of OpenDocument
    odfuserfield - List or change the user-field declarations in an ODF file
    xml2odf - Create OD? package from OpenDocument in XML form

%package -n %packagename
Summary: Python library for manipulating OpenDocument files
Group: Development/Python
License: GPLv2+

%description -n %packagename
Odfpy aims to be a complete API for OpenDocument in Python. Unlike
other more convenient APIs, this one is essentially an abstraction
layer just above the XML format. The main focus has been to prevent
the programmer from creating invalid documents. It has checks that
raise an exception if the programmer adds an invalid element, adds an
attribute unknown to the grammar, forgets to add a required attribute
or adds text to an element that doesn't allow it.

These checks and the API itself were generated from the RelaxNG
schema, and then hand-edited. Therefore the API is complete and can
handle all ODF constructions, but could be improved in its
understanding of data types.

%package -n python3-module-%name
Summary: Python3 library for manipulating OpenDocument files
Group: Development/Python3
License: GPLv2+

%description -n python3-module-%name
Odfpy aims to be a complete API for OpenDocument in Python. Unlike
other more convenient APIs, this one is essentially an abstraction
layer just above the XML format. The main focus has been to prevent
the programmer from creating invalid documents. It has checks that
raise an exception if the programmer adds an invalid element, adds an
attribute unknown to the grammar, forgets to add a required attribute
or adds text to an element that doesn't allow it.

These checks and the API itself were generated from the RelaxNG
schema, and then hand-edited. Therefore the API is complete and can
handle all ODF constructions, but could be improved in its
understanding of data types.

%prep
%setup -n %name-%version

%build
%python_build
%python3_build

%install
%python_install
%python3_install

%files -n %packagename
%docdir examples
%docdir contrib
%python_sitelibdir/*egg-info
%python_sitelibdir/odf/

%files
%_bindir/*
%_man1dir/*

%files -n python3-module-%name
%docdir examples
%docdir contrib
%python3_sitelibdir/*egg-info
%python3_sitelibdir/odf/

%changelog
