%define soversion 5
Name: oniguruma
Version: 6.9.4
Release: alt1
Summary: Regular expressions library

Group: System/Libraries
License: BSD
Url: https://github.com/kkos/oniguruma/
Source0: %name-%version.tar


%description
Oniguruma is a regular expressions library.
The characteristics of this library is that different character encoding
for every regular expression object can be specified.
(supported APIs: GNU regex, POSIX and Oniguruma native)

%package -n lib%name%soversion
Summary: Regular expressions library
Group: System/Libraries

%description -n lib%name%soversion
Oniguruma is a regular expressions library.
The characteristics of this library is that different character encoding
for every regular expression object can be specified.
(supported APIs: GNU regex, POSIX and Oniguruma native)

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/Other
Requires: lib%name%soversion = %EVR
Provides: libOniGuruma-devel = %EVR
Provides: %name-devel = %EVR
Obsoletes: %name-devel
Obsoletes: libOniGuruma-devel

%description -n lib%name-devel
The lib%name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup
%__sed -i.multilib -e 's|-L@libdir@||' onig-config.in

for f in \
	README.ja \
	doc/API.ja \
	doc/FAQ.ja \
	doc/RE.ja
	do
	iconv -f EUC-JP -t UTF-8 $f > $f.tmp && \
		( touch -r $f $f.tmp ; %__mv -f $f.tmp $f ) || \
		%__rm -f $f.tmp
done

%build
autoreconf -fisv
%configure \
    --disable-silent-rules \
	--disable-static \
	--with-rubydir=%_bindir
%__make

%install
%__make install \
	DESTDIR=$RPM_BUILD_ROOT \
	INSTALL="%__install -c -p"
find $RPM_BUILD_ROOT -name '*.la' \
	-exec %__rm -f {} ';'

%check
%__make check

%files -n lib%name%soversion
%doc	AUTHORS COPYING HISTORY README index.html
%_libdir/libonig.so.%{soversion}*

%files -n lib%name-devel
%doc	doc/API doc/FAQ doc/RE
%_bindir/onig-config
%_libdir/libonig.so
%_includedir/onig*.h
%_libdir/pkgconfig/%name.pc

%changelog
