# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name opencdk
%define libgcrypt_version 1.1.94

%define major	10
%define libname lib%{name}%{major}
%define libname_orig lib%{name}
%define develname lib%{name}-devel

Summary:	Open Crypto Development Kit
Name:		opencdk
Version:	0.6.6
Release:	alt1_13
License:	GPLv2+
Group:		System/Libraries
URL:		http://www.gnutls.org/
Source0:	http://www.gnu.org/software/gnutls/releases/opencdk/%{name}-%{version}.tar.bz2
Source1:	http://www.gnu.org/software/gnutls/releases/opencdk/%{name}-%{version}.tar.bz2.sig
Patch0:		opencdk-0.6.6-link.patch
BuildRequires:	pkgconfig(zlib)
BuildRequires:	gcrypt-utils libgcrypt-devel
Source44: import.info

%description
%{name} library provides basic parts of the OpenPGP message format.
Due to some possible security problems, the library also implements
parts of draft-ietf-openpgp-rfc2440bis-08.txt.

The aim of the library is *not* to replace any available OpenPGP version.
There will be no real support for key management (sign, revoke,
alter preferences, ...) and some other parts are only rudimentary
available. The main purpose is to handle and understand OpenPGP
packets and to use basic operations. For example to encrypt/decrypt
or to sign/verify and packet routines.

%package -n	%{libname}
Summary:	Open Crypto Development Kit
Group:		System/Libraries
Provides:	%{name} = %{version}-%{release}
Provides:	%{libname_orig} = %{version}-%{release}

%description -n	%{libname}
%{name} library provides basic parts of the OpenPGP message format.
Due to some possible security problems, the library also implements
parts of draft-ietf-openpgp-rfc2440bis-08.txt.

The aim of the library is *not* to replace any available OpenPGP version.
There will be no real support for key management (sign, revoke,
alter preferences, ...) and some other parts are only rudimentary
available. The main purpose is to handle and understand OpenPGP
packets and to use basic operations. For example to encrypt/decrypt
or to sign/verify and packet routines.


%package -n	%{develname}
Summary:	Development files for %{name}
Group:		Development/Other
Provides:	%{name}-devel = %{version}-%{release}
Provides:	%{libname_orig}-devel = %{version}-%{release}
Requires:	%{libname} = %{version}-%{release}
Requires:	gcrypt-utils
Obsoletes:	lib%{name}8-devel

%description -n	%{develname}
%{name} library provides basic parts of the OpenPGP message format.

You will need to install this package if you want to develop or 
compile any applications/libraries that use %{name}.

%prep
%setup -q
%patch0 -p1

%build
# fix build on aarch64
autoreconf -vfi

%configure --disable-static
%make_build

%install
%makeinstall_std
rm -f %{buildroot}%{_libdir}/*.la

install -D -m 644 src/opencdk.m4 %{buildroot}%{_datadir}/aclocal/opencdk.m4

echo #multiarch_binaries %{buildroot}%{_bindir}/*-config

%files -n %{libname}
%doc COPYING
%{_libdir}/lib*.so.%{major}*

%files -n %{develname}
%doc AUTHORS ChangeLog NEWS README THANKS TODO
%doc doc/opencdk-api.html
%{_bindir}/opencdk-config
#multiarch %{multiarch_bindir}/*-config
%{_datadir}/aclocal/*.m4
%{_includedir}/*
%{_libdir}/lib*.so
%{_libdir}/pkgconfig/opencdk.pc


%changelog
