%define libsover 22

%define rname OpenEXR
Name: openexr22
Version: 2.2.0
Release: alt5

%define common %name-common
%define libilmimf libilmimf%libsover
%define libilmimfutil libilmimfutil%libsover

Group: System/Libraries
Summary: A high-dynamic-range image file library
License: BSD
URL: http://www.openexr.org/

Requires: %libilmimf = %version-%release
Provides: %rname = %version-%release
Obsoletes: %rname < %version-%release

Source: openexr-%version.tar
# FC
Patch1: openexr-2.1.0-bigendian.patch
# ALT
Patch10: openexr-2.2.0-alt-build.patch
Patch11: openexr-2.1.0-alt-libdir.patch
Patch12: openexr-2.1.0-alt-pkgconfig.patch
Patch13: alt-gcc8.patch

# Automatically added by buildreq on Thu Apr 21 2011 (-bi)
# optimized out: elfutils libstdc++-devel pkg-config
#BuildRequires: gcc-c++ glibc-devel-static ilmbase-devel zlib-devel
BuildRequires: gcc-c++ glibc-devel ilmbase12-devel zlib-devel
BuildRequires: cmake kde-common-devel

%description
OpenEXR is an image file format and library developed by Industrial Light
& Magic, and later released to the public. It provides support for high
dynamic range and a 16-bit floating point "half" data type which is
compatible with the half data type in the Cg programming language.


%package -n %common
Group: System/Configuration/Other
Summary: Common empty package for %name
%description -n %common
Common empty package for %name

%package -n %libilmimf
Group: System/Libraries
Summary: libIlmImf %rname library
Requires: %common = %version-%release
Conflicts: openexr <= 1.6.1-alt1
%description -n %libilmimf
libIlmImf %rname library

%package -n %libilmimfutil
Group: System/Libraries
Summary: libIlmImfUtil %rname library
Requires: %common = %version-%release
Conflicts: openexr <= 1.6.1-alt1
%description -n %libilmimfutil
libIlmImfUtil %rname library

%package devel
Summary: Headers for developing programs that will use %rname
Group: Development/Other
Requires: %common = %version-%release
Conflicts: openexr-devel
#
%description devel
This package contains the static libraries and header files needed for
developing applications with %rname

%prep
%setup -q -n openexr-%version
%patch1 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1

%build
%Kcmake
%Kmake

%install
%Kinstall

# create compatibility symlinks
for f in %buildroot/%_libdir/lib*.so ; do
    fname=`basename $f`
    newname=`echo $fname | sed 's|-.*|.so|'`
    [ "$fname" == "$newname" ] \
	|| ln -s $fname %buildroot/%_libdir/$newname
done

mv %buildroot/%_docdir/%rname-%version %buildroot/%_docdir/%name-%version
install -m 0644 AUTHORS %buildroot/%_docdir/%name-%version/
install -m 0644 ChangeLog %buildroot/%_docdir/%name-%version/
install -m 0644 COPYING %buildroot/%_docdir/%name-%version/
install -m 0644 NEWS %buildroot/%_docdir/%name-%version/
install -m 0644 README %buildroot/%_docdir/%name-%version/

%files -n %common

%files -n %libilmimf
%_libdir/libIlmImf-*.so.%libsover
%_libdir/libIlmImf-*.so.%libsover.*
%files -n %libilmimfutil
%_libdir/libIlmImfUtil-*.so.%libsover
%_libdir/libIlmImfUtil-*.so.%libsover.*

%files devel
%doc %_docdir/%name-%version/
%_includedir/%rname
%_libdir/lib*.so
%_libdir/pkgconfig/*
#%_datadir/aclocal/%name.m4


%changelog
