#define udapl 1
#define static 1
%define thread 1

# Build examples package only once
%ifndef udapl
%ifndef thread
%define examples 1
%endif
%endif

%ifdef udapl
%define udaplpkg openmpi-udapl
%define udaplarg --with-udapl
%else
%define udaplpkg openmpi
%define udaplarg --without-udapl
%endif

%ifdef thread
%define threadpkg %udaplpkg-threads
%define threadarg --with-threads=posix --enable-mpi-threads --enable-progress-threads --enable-ft-thread
%else
%define threadpkg %udaplpkg
%define threadarg --without-threads --disable-ft-thread --disable-mpi-threads
%endif


%ifdef static
%define pkgname %threadpkg-static
%define staticarg --enable-static --disable-shared
%else
%define pkgname %threadpkg
%define staticarg --disable-static
%endif

%define arguments %udaplarg %threadarg %staticarg

Name: openmpi-compat
#pkgname

Version: 1.6.4
Release: alt5

%define mpi_prefix %_libdir/%name
%define mpi_sysconfdir %_sysconfdir/%name

Summary: A powerful implementaion of MPI
Summary(ru_RU.UTF8): Открытая реализация MPI
License: BSD
Group: Development/Other
Url: http://www.open-mpi.org/

Packager: Denis Pynkin <dans@altlinux.ru>
Source:  openmpi-%version.tar
#Source1: MPI_Status_c2f.3

Patch0: openmpi-%version-%release.patch
#Patch1: openmpi-arm-%version.patch

BuildPreReq: rpm-macros-mpi-selector
Requires(post,preun): mpi-selector

%ifdef static
BuildPreReq: libibverbs-devel-static >= 1.1.2
%endif

%ifdef udapl
%ifdef static
BuildPreReq: libdapl-devel-static libstdc++-devel-static
%endif
Requires: libdapl >= 1.2.12
BuildPreReq: libdapl-devel
%endif

%ifdef thread
BuildPreReq: glibc-pthread
%endif

Requires: libibverbs >= 1.1.2
BuildPreReq: /proc flex gcc-c++ gcc-fortran
BuildPreReq: rdma-core-devel
BuildPreReq: valgrind-devel libiberty-devel

%package -n openmpi-lib-compat
Summary: Provides links to OpenMPI libraries v.1
Group: Development/Other

Requires: %name = %version-%release
Obsoletes: openmpi < %version-%release
Provides: openmpi = %version-%release
Provides: %_libdir/openmpi/lib/libmpi_cxx.so.1
Provides: %_libdir/openmpi/lib/libmpi_f77.so.1
Provides: %_libdir/openmpi/lib/libmpi_f90.so.1
Provides: %_libdir/openmpi/lib/libmpi.so.1

%package -n openmpi-lib-compat-debuginfo
Summary: Provides links to OpenMPI v.1 debuginfo
Group: Development/Other

Requires: %name-debuginfo = %version-%release
Obsoletes: openmpi-debuginfo < %version-%release
Provides: openmpi-debuginfo = %version-%release
Provides: %_libexecdir/debug%{_libdir}/openmpi/lib/libmpi_cxx.so.1.debug
Provides: %_libexecdir/debug%{_libdir}/openmpi/lib/libmpi_f77.so.1.debug
Provides: %_libexecdir/debug%{_libdir}/openmpi/lib/libmpi_f90.so.1.debug
Provides: %_libexecdir/debug%{_libdir}/openmpi/lib/libmpi.so.1.debug

%package devel
Summary: Development part of %name
Group: Development/Other

Requires: %name = %version-%release
Requires: gcc-c++ gcc-fortran
Requires: rdma-core-devel

Obsoletes: openmpi-devel < %version-%release

%ifdef udapl
Requires: libdapl-devel
%endif

%package devel-vt
Summary: Development part of %name. VampirTrace related stuff.
Group: Development/Other

Requires: %name-devel = %version-%release
Requires: gcc-c++ gcc-fortran
Requires: rdma-core-devel

Obsoletes: openmpi-vt < %version-%release

%ifdef examples
%package %name-examples
Summary: Generic examples for %name.
Group: Development/Other
BuildArch: noarch

%description %name-examples
Examples comming with upstream sources tarball.
%endif

%description
Open MPI is a project combining technologies and resources from
several other projects (FT-MPI, LA-MPI, LAM/MPI, and PACX-MPI) in
order to build the best MPI library available. A completely new
MPI-2 compliant implementation, Open MPI offers advantages for
system and software vendors, application developers and computer
science researchers.

This part is attended for computing nodes.
#description -l ru_RU.KOI8-R

%description -n openmpi-lib-compat
Provides links to OpenMPI libraries v.1.
Sonames has been changed in later versions of OpenMPI

%description -n openmpi-lib-compat-debuginfo
Provides links to OpenMPI v.1 debuginfo
Sonames has been changed in later versions of OpenMPI

%description devel
Package for development with Open MPI

%description devel-vt
Package for development with Open MPI and VampirTrace

%prep
%setup -q -n openmpi-%version
#__cp -f SOURCE1 ompi/mpi/man/man3/
%patch0 -p1
#patch1 -p1

%build
CFLAGS+=" %optflags -D_FORTIFY_SOURCE=2"
CXXFLAGS+=" %optflags"
LDFLAGS+="-Wl,-R%mpi_prefix/lib/openmpi:%mpi_prefix/lib"
echo="/bin/echo"
export CFLAGS CXXFLAGS LDFLAGS echo

#autoreconf
sh autogen.sh

function buildIt() {
	./configure $* \
			--enable-mpi-f77 \
			--enable-mpi-f90 \
			--prefix=%mpi_prefix \
			--with-ft=cr \
			--sysconfdir=%mpi_sysconfdir \
			--bindir=%mpi_prefix/bin \
			--libdir=%mpi_prefix/lib \
			--datadir=%mpi_prefix/data \
			--includedir=%mpi_prefix/include \
			--mandir=%mpi_prefix/man \
			--docdir=%_docdir/%name-%version \
			--with-gnu-ld \
			--with-wrapper-ldflags="-Wl,--no-as-needed,-Rpath=%mpi_prefix/lib"

	%make_build
}

buildIt %arguments

%install
echo="/bin/echo"
export echo

%make_install DESTDIR=%buildroot install

#ln -s ompi-restart %buildroot%_libdir/%name/bin/orte-restart
#ln -s ompi-checkpoint %buildroot%_libdir/%name/bin/orte-checkpoint

# Avoid fail during man pages compression
rm -f %buildroot%_libdir/%name/man/man1/mpiCC.1
rm -f %buildroot%_libdir/%name/man/man1/orteCC.1

ln -s mpic++.1.gz %buildroot%_libdir/%name/man/man1/mpiCC.1.gz
ln -s mpic++.1.gz %buildroot%_libdir/%name/man/man1/orteCC.1.gz

%find_lang %name

echo -e "btl = tcp,self\n" >> %buildroot%mpi_sysconfdir/openmpi-mca-params.conf

cat>%buildroot/%mpi_prefix/bin/mpivars.sh<<EOF
if ! echo \$PATH | grep -q %mpi_prefix/bin ; then
    PATH=%mpi_prefix/bin:\$PATH
    export PATH
fi

if ! echo \$LD_LIBRARY_PATH | grep -q %mpi_prefix/lib ; then
    LD_LIBRARY_PATH=%mpi_prefix/lib\${LD_LIBRARY_PATH:+:\$LD_LIBRARY_PATH}
    export LD_LIBRARY_PATH
fi

if ! echo \$MANPATH | grep -q %mpi_prefix/man ; then
    MANPATH=%mpi_prefix/man:\$MANPATH
    export MANPATH
fi
EOF

cat >%buildroot%mpi_prefix/bin/mpivars.csh <<EOF
if (\$?path) then
    if ( "\${path}" !~ *%mpi_prefix/bin* ) then
	set path = ( %mpi_prefix/bin \$path )
    endif
else
    set path = ( %mpi_prefix/bin )
endif

if (\$?LD_LIBRARY_PATH) then
    if ( "\$LD_LIBRARY_PATH" !~ *%mpi_prefix/lib* ) then
	setenv LD_LIBRARY_PATH %mpi_prefix/lib:\$LD_LIBRARY_PATH
    endif
else
    setenv LD_LIBRARY_PATH %mpi_prefix/lib
endif

if (\$?MANPATH) then
    if ( "\$MANPATH" !~ *%mpi_prefix/man* ) then
	setenv MANPATH %mpi_prefix/man:\$MANPATH
    endif
else
    setenv MANPATH %mpi_prefix/man
endif
EOF

mkdir -p %buildroot%_libdir/openmpi/lib
ln -fs ../../%name/lib/libmpi_cxx.so.1 %buildroot%_libdir/openmpi/lib/libmpi_cxx.so.1
ln -fs ../../%name/lib/libmpi_f77.so.1 %buildroot%_libdir/openmpi/lib/libmpi_f77.so.1
ln -fs ../../%name/lib/libmpi_f90.so.1 %buildroot%_libdir/openmpi/lib/libmpi_f90.so.1
ln -fs ../../%name/lib/libmpi.so.1 %buildroot%_libdir/openmpi/lib/libmpi.so.1

mkdir -p %buildroot%_libexecdir/debug%_libdir/openmpi/lib
ln -fs ../../%name/lib/libmpi_cxx.so.1 %buildroot%_libexecdir/debug%_libdir/openmpi/lib/libmpi_cxx.so.1
ln -fs ../../%name/lib/libmpi_f77.so.1 %buildroot%_libexecdir/debug%_libdir/openmpi/lib/libmpi_f77.so.1
ln -fs ../../%name/lib/libmpi_f90.so.1 %buildroot%_libexecdir/debug%_libdir/openmpi/lib/libmpi_f90.so.1
ln -fs ../../%name/lib/libmpi.so.1 %buildroot%_libexecdir/debug%_libdir/openmpi/lib/libmpi.so.1


%post
%post_mpi_selector %name %mpi_prefix/bin

%preun
%preun_mpi_selector %name

%files -f %name.lang
%doc AUTHORS LICENSE NEWS README VERSION 

%dir %mpi_prefix

%dir %mpi_prefix/bin

%mpi_prefix/bin/mpivars.*
%mpi_prefix/bin/mpirun
%mpi_prefix/bin/ompi_info
%mpi_prefix/bin/opal_wrapper
%mpi_prefix/bin/orted
%mpi_prefix/bin/orterun
%mpi_prefix/bin/mpiexec

%mpi_prefix/bin/ompi-*
%mpi_prefix/bin/orte-*
%mpi_prefix/bin/opal-*

%dir %mpi_prefix/lib
%dir %mpi_prefix/lib/openmpi
%mpi_prefix/lib/openmpi/*.so

%ifdef static
%mpi_prefix/lib/lib*
%exclude %mpi_prefix/lib/libvt*
%else
%mpi_prefix/lib/lib*.so.*
%endif

%dir %mpi_sysconfdir
%config(noreplace) %mpi_sysconfdir/*

%dir %mpi_prefix/man
%mpi_prefix/man/man1
%mpi_prefix/man/man7
%mpi_prefix/data

%files -n openmpi-lib-compat
%_libdir/openmpi/lib/libmpi_cxx.so.1
%_libdir/openmpi/lib/libmpi_f77.so.1
%_libdir/openmpi/lib/libmpi_f90.so.1
%_libdir/openmpi/lib/libmpi.so.1

%files -n openmpi-lib-compat-debuginfo
%_libexecdir/debug%_libdir/openmpi/lib/libmpi_cxx.so.1.debug
%_libexecdir/debug%_libdir/openmpi/lib/libmpi_f77.so.1.debug
%_libexecdir/debug%_libdir/openmpi/lib/libmpi_f90.so.1.debug
%_libexecdir/debug%_libdir/openmpi/lib/libmpi.so.1.debug

%files devel
%mpi_prefix/bin/mpic++
%mpi_prefix/bin/mpicc
%mpi_prefix/bin/mpiCC
%mpi_prefix/bin/mpicxx
%mpi_prefix/bin/mpif77
%mpi_prefix/bin/mpif90
%mpi_prefix/bin/otf*

%mpi_prefix/bin/orte_wrapper_script
%mpi_prefix/bin/orteCC
%mpi_prefix/bin/ortec++
%mpi_prefix/bin/ortecc

%dir %mpi_prefix/include
%mpi_prefix/include/*.h
%dir %mpi_prefix/include/openmpi
%mpi_prefix/include/openmpi/*

%mpi_prefix/man/man3

%mpi_prefix/lib/mpi.mod

%mpi_prefix/lib/pkgconfig/*

%ifdef static
%mpi_prefix/lib/openmpi/*.a
%mpi_prefix/lib/libotf.a
%else
%exclude %mpi_prefix/lib/libvt*.so
%mpi_prefix/lib/lib*.so
%mpi_prefix/lib/*.la
%mpi_prefix/lib/openmpi/*.la
%endif

%files devel-vt
%mpi_prefix/bin/mpic++-vt
%mpi_prefix/bin/mpicc-vt
%mpi_prefix/bin/mpiCC-vt
%mpi_prefix/bin/mpicxx-vt
%mpi_prefix/bin/mpif77-vt
%mpi_prefix/bin/mpif90-vt
%mpi_prefix/bin/vt*
%mpi_prefix/lib/libvt*.so
%dir %mpi_prefix/include/vampirtrace
%mpi_prefix/include/vampirtrace/*

%ifdef examples
%files %name-examples
%doc examples
%endif

%changelog
