%define subscribers_dir /lib/resolvconf

Name: openresolv
Version: 3.9.2
Release: alt1

Summary: A framework for managing DNS information 
License: %bsdstyle
Group: System/Configuration/Networking

URL: http://roy.marples.name/projects/%name
Source: %name-%version.tar
Source1: test
Patch0: %name-%version-%release.patch
BuildArch: noarch

BuildRequires(pre): rpm-build-licenses

Requires: filesystem >= 2.3.5

# pdnsd support
%def_with pdnsd
# PowerDNS support
%def_with pdns

%define _unpackaged_files_terminate_build 1

%description
resolvconf is the middleman between the network
configuration services and /etc/resolv.conf.
resolvconf itself is just a script that stores,
removes and lists a full resolv.conf generated
for the interface. It then calls all the helper
scripts it knows about so it can configure the real
/etc/resolv.conf and optionally any local nameservers
other can libc.

%package bind
Summary: bind subscriber for openresolv
Group: System/Configuration/Networking
Requires: %name = %version-%release
Requires: bind

%description bind
bind subscriber for openresolv

%package dnsmasq
Summary: dnsmasq subscriber for openresolv
Group: System/Configuration/Networking
Requires: %name = %version-%release
Requires: dnsmasq >= 2.65-alt1

%description dnsmasq
dnsmasq subscriber for openresolv

%package unbound
Summary: unbound subscriber for openresolv
Group: System/Configuration/Networking
Requires: %name = %version-%release
Requires: unbound

%description unbound
unbound subscriber for openresolv

%if_with pdnsd
%package pdnsd
Summary: pdnsd subscriber for openresolv
Group: System/Configuration/Networking
Requires: %name = %version-%release
Requires: pdnsd

%description pdnsd
pdnsd subscriber for openresolv
%endif

%if_with pdns
%package pdns
Summary: PowerDNS subscriber for openresolv
Group: System/Configuration/Networking
Requires: %name = %version-%release
Requires: pdns

%description pdns
PowerDNS subscriber for openresolv
%endif

%prep
%setup -q
%patch0 -p1
cp %SOURCE1 .

%build
./test
%configure --sbindir=/sbin --libexecdir=/lib/resolvconf \
           --localstatedir=%_var \
           --rundir=%_var/run \
           --os=linux
%make

%install
%makeinstall_std

mkdir -p %buildroot%_sysconfdir/dnsmasq.conf.d
touch %buildroot%_sysconfdir/dnsmasq.conf.d/60-resolvconf
touch %buildroot%_sysconfdir/resolv.conf.dnsmasq
mkdir -p %buildroot%_localstatedir/bind/etc
touch %buildroot%_localstatedir/bind/etc/resolvconf-zones.conf
touch %buildroot%_localstatedir/bind/etc/resolvconf-options.conf

%files
/sbin/*
%_man5dir/*
%_man8dir/*
%dir %subscribers_dir
%subscribers_dir/libc
%config(noreplace) %_sysconfdir/resolvconf.conf

%files bind
%subscribers_dir/named
%ghost %_localstatedir/bind/etc/resolvconf-zones.conf
%ghost %_localstatedir/bind/etc/resolvconf-options.conf

%files dnsmasq
%subscribers_dir/dnsmasq
%config(noreplace) %_sysconfdir/resolv.conf.dnsmasq
%ghost %_sysconfdir/dnsmasq.conf.d/60-resolvconf

%files unbound
%subscribers_dir/unbound

%if_with pdnsd
%files pdnsd
%subscribers_dir/pdnsd
%else
%exclude %subscribers_dir/pdnsd
%endif

%if_with pdns
%files pdns
%subscribers_dir/pdns_recursor
%else
%exclude %subscribers_dir/pdns_recursor
%endif

%changelog
