# spec file for package opie (Version 2.4)
#
# Copyright (c) 2010 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://bugs.opensuse.org/

Name: opie
#!BuildIgnore: opie
BuildRequires: bison libpam-devel
Url: http://www.inner.net/opie
Version: 2.4
Release: alt1
License: GPLv2+
Group: System/Base
Provides: pam_opie
%define name_pam         pam_opie
%define version_pam	 0.21
Packager: Mykola Grechukh <gns@altlinux.ru>

Source: %name-%version.tar.bz2
Source1: %name_pam-%version_pam.tar.bz2
Source2: baselibs.conf
Patch: %name-%version.diff
Patch1: %name_pam-%version_pam.diff
Patch2: %name-%version.newseed.diff
Patch3: uint4_def.patch
Patch4: %name-2.4-bison.patch
Patch5: %name-2.4-nonvoid.patch
Patch6: %name-2.4-decl.diff
Patch7: %name-2.4-nul-overflow.patch
Patch8: %name-2.4-cxx.patch
Patch9: %name-2.4-undef.patch
Patch10: %name-2.4-noroot.patch
Patch11: %name-%{version}_array-subscript.patch
Patch12: %name_pam-%{version_pam}_array-subscript.patch
Patch13: %name-2.4-getline.patch
Patch14: %name-2.4-fclose.patch
Summary: Support for One-Time Passwords

%description
OPIE stands for One-time Passwords In Everything. One-time passwords
can be used to foil password sniffers because they cannot be reused by
the attacker.

This package provides a PAM module and several utility programs that
let you use one-time passwords for authentication.

%package devel
Summary: development headers for opie
Group: Development/C

%description devel
OPIE stands for One-time Passwords In Everything. One-time passwords
can be used to foil password sniffers because they cannot be reused by
the attacker.

This package provides include files required to link applications with opie

%prep
%setup -n %name-%version -a 1
%patch0 -p1
%patch2 -p1
%patch3
%patch4
%patch5
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9
perl -pi -e 's/(?<!DESTDIR\))\$\(KEY_FILE\)/\$\(DESTDIR\)\$\(KEY_FILE\)/g' Makefile.in
perl -pi -e 's/(?<!DESTDIR\))\$\(LOCK_DIR\)/\$\(DESTDIR\)\$\(LOCK_DIR\)/g' Makefile.in
perl -pi -e 's/(?<!DESTDIR\))\$\(LOCALBIN\)/\$\(DESTDIR\)\$\(LOCALBIN\)/g' Makefile.in
perl -pi -e 's/(?<!DESTDIR\))\$\(LOCALMAN\)/\$\(DESTDIR\)\$\(LOCALMAN\)/g' Makefile.in
%patch10 -p1
%patch11
cd %name_pam
%patch1 -p0
%patch12
cd ..
%patch13
%patch14

%build
# build opie
export CFLAGS="$RPM_OPT_FLAGS -fno-strict-aliasing"
%configure --enable-insecure-override
%make_build
# build pam_opie
cd %name_pam
%make_build

%install
# install opie
mkdir -p %buildroot/etc
mkdir -p %buildroot%_man1dir/
#
make CHOWN=/bin/echo DESTDIR=%buildroot install
install -m 644 -D opie.h %buildroot%_includedir/opie.h
install -m 644 -D libopie/libopie.a %buildroot%_libdir/libopie.a
mv %name_pam/README ./README.PAM
# install pam_opie
cd %name_pam
make FAKEROOT=%buildroot \
     SECUREDIR=/%_lib/security install

%files
%dir %_sysconfdir/opielocks
%config(noreplace) %_sysconfdir/opiekeys
%_bindir/*
/%_lib/security/pam_opie.so
#_libdir/libopie.a
%doc BUG-REPORT COPYRIGHT.NRL INSTALL License.TIN README README.PAM
%doc %_mandir/man*/*
%files devel
/%_includedir/opie.h

%changelog
