%define includedir %_includedir/%name

Name: p7zip
Version: 16.02
Release: alt5

Summary: 7zip unofficial port - a file-archiver with highest compression ratio
License: Freely distributable
Group: Archiving/Compression

Url: http://p7zip.sourceforge.net/
Source: %{name}_%{version}_src_all.tar
# debian patches
Patch1: 12-CVE-2016-9296.patch
Patch2: 13-CVE-2017-17969.patch
Patch3: 06-CVE-2018-5996.patch
Patch4: CVE-2018-10115.patch

# Automatically added by buildreq on Sat Oct 08 2011
# optimized out: libstdc++-devel
BuildRequires: gcc-c++
%ifarch %ix86
BuildRequires: nasm
%endif
%ifarch x86_64
BuildRequires: yasm
%endif

%description
p7zip is a port of 7-Zip for Unix. 7-Zip is a file archiver
with a very high compression ratio.

%package standalone
Summary: Standalone p7zip executable without plugins
Group: Archiving/Compression
License: LGPLv2.1+
Requires: p7zip

%description standalone
p7zip is a port of 7-Zip for Unix. 7-Zip is a file archiver
with a very high compression ratio.

This package contains standalone version of p7zip.
It handles less archive formats than plugin capable version.

%package devel
Summary: Development package of p7zip that includes the header files
Group: Development/C
License: Public domain
BuildArch: noarch

Requires: %name = %EVR

%description devel
The devel package contains the p7zip include files.

%prep
%setup -n p7zip_%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build
%ifarch %e2k
# _LITTLE_ENDIAN gets defined but not checked for
%add_optflags -D__LITTLE_ENDIAN__
# -ffast is faster but its -floop-apb-conditional-loads is potentially dangerous
%add_optflags -fcache-opt
%endif

# Make p7zip looks for plugins in fixed directory. Upstream behavior was to
# look in current directory by default (when environment variable P7ZIP_HOME_DIR
# is not set)
find . -name '*.cpp' -exec \
subst 's@getenv("P7ZIP_HOME_DIR")@"%_libdir/p7zip/"@g' {} \;

%ifarch %ix86
cp -f makefile.linux_x86_asm_gcc_4.X makefile.machine
%endif
%ifarch x86_64
cp -f makefile.linux_amd64_asm makefile.machine
%endif

# NB: 'all' is not default target in this makefile
%make_build OPTFLAGS="%optflags" all2

# NB: Someday I probably should build and package 7zG (7z GUI), but for now
# this GUI is far from useful.

%install
./install.sh %_bindir %_libdir/p7zip %_mandir %_docdir/%name-%version %buildroot
# Install script put shell wrappers in /usr/bin/ instead of executables.
# We don't want this, see comments to inline patch above to get idea of our way.
mv -f %buildroot%_libdir/p7zip/{7z,7za} %buildroot%_bindir/

# Install C/*.h files
mkdir -p %buildroot%includedir
find C -maxdepth 1 -mindepth 1 -name '*.h' -a -not \( -name Threads.h -o -name LzFindMt.h -o -name MtCoder.h \) -print0 | \
xargs -0 install -pm644 -t %buildroot%includedir/

%files
%doc README ChangeLog DOC
%_bindir/7z
%dir %_libdir/p7zip
%_libdir/p7zip/*.so
%_libdir/p7zip/*.sfx
%_libdir/p7zip/Codecs
%_man1dir/7z.*
%exclude %_man1dir/7zr.*

%files standalone
%_bindir/7za
%_man1dir/7za.*

%files devel
%includedir

%changelog
