%def_disable snapshot

%define ver_major 4.2
%define _name files
%define xdg_name org.pantheon.%_name
%define rdn_name io.elementary.%_name

Name: pantheon-files
Version: %ver_major.0
Release: alt1

Summary: The file manager of the Pantheon desktop
License: GPLv3
Group: File tools
Url: https://github.com/elementary/%_name

%if_disabled snapshot
Source: %url/archive/%version/%_name-%version.tar.gz
%else
#VCS: https://github.com/elementary/files.git
Source: %_name-%version.tar
%endif

Provides: %rdn_name = %version-%release

#Depends: tumbler
#Recommends: contractor
#Suggests: tumbler-plugins-extra
Requires: polkit zeitgeist tumbler elementary-icon-theme

BuildRequires(pre): meson
BuildRequires: intltool libappstream-glib-devel
BuildRequires: vala-tools libsqlite3-devel libgtk+3-devel
BuildRequires: libgee0.8-devel libgranite-devel
BuildRequires: libgail3-devel libdbus-glib-devel libnotify-devel
BuildRequires: libxkbcommon-devel libgranite-vala
BuildRequires: libzeitgeist2.0-devel libplank-devel libplank-vala
BuildRequires: libpolkit-devel
BuildRequires: libcanberra-devel libcanberra-vala
BuildRequires: libcloudproviders-devel

%description
The simple, powerful, and sexy file manager from elementary.

%package devel
Summary: Development files for pantheon-files
Group: Development/C
Requires: %name = %version-%release

%description devel
Development files for pantheon-files.

%package vala
Summary: Vala language bindings for the pantheon-files
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %version-%release

%description vala
This package provides Vala language bindings for the pantheon-files.

%prep
%setup -n %_name-%version

%build
%meson -Dwith-unity=false
%meson_build

%install
%meson_install
%find_lang %rdn_name

%files -f %rdn_name.lang
%doc AUTHORS README*
%_bindir/*
%_libdir/*.so.*
%_libdir/gtk-3.0/modules/libpantheon-filechooser-module.so
%_libdir/%rdn_name/
%_desktopdir/%rdn_name.desktop
%_datadir/dbus-1/services/%rdn_name.service
%_datadir/dbus-1/services/%rdn_name.Filemanager1.service
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/polkit-1/actions/%rdn_name.policy
%_datadir/%rdn_name/
%dir %_pixmapsdir/%rdn_name
%_pixmapsdir/%rdn_name/*.png
%_datadir/metainfo/%rdn_name.appdata.xml

%files devel
%_includedir/%name-widgets.h
%_includedir/%name-core/
%_libdir/*.so
%_pkgconfigdir/%name-core.pc
%_pkgconfigdir/%name-widgets.pc

%if 0
%files vala
%_vapidir/%name-core.vapi
%_vapidir/%name-widgets.vapi
%endif

%changelog
