%def_disable snapshot

%define ver_major 5.3
%define _name terminal
%define xdg_name org.pantheon.%_name
%define rdn_name io.elementary.%_name

Name: pantheon-terminal
Version: %ver_major.5
Release: alt1

Summary: Pantheon Terminal
Group: Terminals
License: GPLv3
Url: https://github.com/elementary/terminal

%if_disabled snapshot
Source: %url/archive/%version/%_name-%version.tar.gz
%else
#VCS: https://github.com/elementary/terminal.git
Source: %_name-%version.tar
%endif

Requires: elementary-icon-theme
Provides: %rdn_name = %version-%release

BuildRequires(pre): meson
BuildRequires: appstream desktop-file-utils
BuildRequires: libgranite-devel libnotify-devel libvte3-devel libgee0.8-devel
BuildRequires: vala-tools libgranite-vala

%description
Pantheon Terminal (referred to simply as "Terminal" when installed) is a super
lightweight, beautiful, and simple terminal.

It's designed to be setup with sane defaults and little to no configuration.
It's just a terminal, nothing more, nothing less.

%package vala
Summary: Vala language bindings for the %name
Group: Development/Other
BuildArch: noarch
#Requires: %name-devel = %version-%release

%description vala
This package provides Vala language bindings for the %name.


%prep
%setup -n %_name-%version

%build
%meson -Dubuntu-bionic-patched-vte=false
%meson_build

%install
%meson_install

%find_lang %rdn_name

%files -f %rdn_name.lang
%doc AUTHORS README*
%_bindir/%rdn_name
%_datadir/%rdn_name/
%_desktopdir/%rdn_name.desktop
%_desktopdir/open-%name-here.desktop
%_datadir/glib-2.0/schemas/%rdn_name.gschema.xml
%_datadir/metainfo/%rdn_name.appdata.xml

%exclude %_datadir/fish/vendor_conf.d/pantheon_terminal_process_completion_notifications.fish

%if 0
%files vala
%_vapidir/*
%endif

%changelog
