%def_enable xfs

Name: partclone
Version: 0.3.6
Release: alt0.3.git96f986f

Summary: File System Clone Utilities
License: GPLv2+
Group: Archiving/Backup

Url: http://partclone.org
# Upstream: git://github.com/Thomas-Tsai/partclone.git
Source: http://download.sourceforge.net/%name/%name-%version.tar
Patch0: partclone-0.3.6-no_fail_mbr.patch

# Automatically added by buildreq on Fri Dec 04 2015
# optimized out: libaal-devel libcom_err-devel libncurses-devel libntfs-3g libtinfo-devel pkg-config xz
BuildRequires: libblkid-devel libe2fs-devel libncursesw-devel libntfs-3g-devel libprogsreiserfs-devel libreiser4-devel libuuid-devel libvmfs-devel

BuildRequires: libvmfs-devel > 0.2.1-alt1
%if_enabled xfs
BuildRequires: libxfs-devel
%endif

# TODO: build with ufs (need libufs2), jfs (need fixed build of jfsutils)

%description
A set of file system clone utilities, including ext2/3/4,%{?_enable_xfs: xfs,}
reiserfs, reiser4, btrfs, ntfs, fat, vmfs, hfs+ file system.

%prep
%setup
%patch0 -p1
echo '#define git_version "%version"' > src/version.h

%build
%autoreconf
# NB: Due to buggy configure checks --disable-somefeature options does not
# switch off configure requirement for correspondent devel packages and
# configure will fail as if --enable-somefeature was in effect.
%configure \
	--enable-btrfs \
	--enable-extfs \
	--enable-reiser4 \
	--enable-reiserfs \
	--enable-hfsp \
	--enable-fat \
	--enable-ntfs \
	--enable-vmfs \
%if_enabled xfs
	--enable-xfs \
%endif
	--enable-ncursesw
%make_build CC="gcc -I/usr/include/vmfs"

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%_sbindir/*
%_man8dir/*

%changelog
