Name: patchutils
Version: 0.3.4
Release: alt1

Summary: Patchutils is a small collection of programs that operate on patch files
License: GPLv2+
Group: Text tools
Url: http://cyberelk.net/tim/patchutils/

# git://git.altlinux.org/gears/p/patchutils.git
Source: %name-%version-%release.tar

Requires: patch, diffutils, mktemp >= 1:1.3.1
Provides: interdiff = %EVR
Obsoletes: interdiff < %EVR

BuildRequires: libzio-devel, xmlto

Summary(ru_RU.UTF-8): Набор программ для обработки патчей

%description
Patchutils is a small collection of programs that operate on patch files.
This version contains:
+ combinediff: creates a cumulative patch from two incremental patches;
+ dehtmldiff: gets usable diff from an HTML page;
+ filterdiff: extracts or excludes diffs from a diff file;
+ fixcvsdiff: fixes problematic cvs diff files;
+ flipdiff: exchanges the order of two incremental patches;
+ grepdiff: shows files modified by a diff containing a regex;
+ espdiff: applies the appropriate transformation to a set of patches;
+ interdiff: shows differences between two unified diff files;
+ lsdiff: shows which files are modified by a patch;
+ recountdiff: recomputes patch counts and offsets;
+ rediff: fixes offsets and counts of a hand-edited diff;
+ splitdiff: separates out incremental patches;
+ unwrapdiff: demangles word-wrapped patches.

%description -l ru_RU.UTF-8
Термином "патч" ("patch", "заплатка") обозначают список отличий
между двумя версиями или вариантами исходного текста, программного
кода или данных.  Патч может иметь как текстовую, так и двоичную форму.

Популярные базовые утилиты diff и patch предназначены для создания
и применения патчей текстового формата для текстовых данных,
в первую очередь - для исходных текстов и конфигурационных файлов,
используемых программистами и системными администраторами.

Данный пакет содержит ряд полезных вспомогательных утилит для работы с патчами:
+ combinediff: создаёт объединённый кумулятивный патч из двух последовательных;
+ dehtmldiff: извлекает текст патча из HTML-страницы;
+ filterdiff: извлекает или исключает diff-отчёты из diff-файла;
+ fixcvsdiff: исправляет возможные ошибки в diff-файлах CVS;
+ flipdiff: меняет порядок наложения двух последовательных патчей;
+ grepdiff: выводит список файлов, изменяемых патчем,
            содержащим указанное регулярное выражение;
+ interdiff: показывает список отличий между двумя патчами;
+ lsdiff: выводит список файлов, изменяемых патчем;
+ recountdiff: заново расчитывает координаты фрагментов патча в исходниках;
+ rediff: исправляет координаты фрагментов во вручную исправлявшемся патче;
+ splitdiff: разделяет последовательные инкрементальные патчи;
+ unwrapdiff: удаляет лишние переносы строк из патчей, выравненных
              в тектовом редакторе по правым границам слов.

%prep
%setup -n %name-%version-%release

%build
%autoreconf
%configure
%make_build

%install
%makeinstall_std

%check
# SMP incompatible checks.
make -k check

%files
%_bindir/*
%_mandir/man?/*
%doc AUTHORS BUGS NEWS* TODO

%changelog
