Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global alternate_name PDFRenderer
%global svn_date 20110310
%global svn_version 128svn

Summary:        A 100% Java PDF renderer and viewer
Name:           pdf-renderer
Version:        0
Release:        alt3_0.21.128svn.20110310jpp8
#src/com/sun/pdfview/decode/CCITTFaxDecoder.java under a BSD-alike License
#src/com/sun/pdfview/font/ttf/resource/glyphlist.txt and src/com/sun/pdfview/font/ttf/AdobeGlyphList.java
#are under Adobe Glyph List License
License:        LGPLv2+ and MIT and BSD
URL:            https://java.net/projects/pdf-renderer/
Source0:        %{name}-%{svn_version}-%{svn_date}.tar.bz2
# To fetch the source code
Source1:        %{name}-snapshot.sh
BuildRequires:  ant
BuildRequires:  ant-apache-regexp
BuildRequires:  java-devel >= 1.7
BuildRequires:  javapackages-local
BuildRequires:  urw-fonts
BuildArch:      noarch

Requires:       urw-fonts
Provides:       %{alternate_name} == %{version}-%{release}
Source44: import.info

%description
The PDF Renderer is just what the name implies: an open source,
all Java library which renders PDF documents to the screen using 
Java2D. Typically this means drawing into a Swing panel, but it 
could also draw to other Graphics2D implementations. It could be 
used to draw on top of PDFs, share them over a network, convert 
PDFs to PNG images, or maybe even project PDFs into a 3D scene.

%package javadoc
Group: Development/Java
Summary:        Javadoc for %{alternate_name}
BuildArch: noarch

%description javadoc
API documentation for the %{alternate_name} package.

%prep
%setup -q -n %{name}-%{svn_version}-%{svn_date}

# Remove preshipped binaries
find . -name "*.jar" -exec rm {} \;

# Fix encoding issues
find . -name "*.java" -exec native2ascii {} {} \;

# Remove preshipped fonts and ...
find . -name "*.pfb" -exec rm {} \;

# ... tell the program to use system-fonts instead.
# Script provided by Mamoru Tasaka:
# https://bugzilla.redhat.com/show_bug.cgi?id=466394#c4
# -------------------------------------------------------------
pushd src/com/sun/pdfview/font/res/
INPUT=BaseFonts.properties
OUTPUT=BaseFonts.properties.1
FONTDIR=%{_datadir}/fonts/default/Type1

rm -f $OUTPUT
cat $INPUT | while read line
 do
 newline=$line
 if echo $newline | grep -q 'file=.*pfb'
  then
  pfbname=$(echo $newline | sed -e 's|^.*file=||')
  newline=$(echo $newline | sed -e "s|file=|file=${FONTDIR}/|")
 elif echo $newline | grep -q 'length='
  then
  size=$(ls -al ${FONTDIR}/$pfbname | awk '{print $5}')
  newline=$(echo $newline | sed -e "s|length=.*|length=$size|")
 fi
 echo $newline >> $OUTPUT
done
mv -f $OUTPUT $INPUT
popd
# -------------------------------------------------------------

%build
%ant \
 -Djavadoc.additionalparam="-Xdoclint:none" \
 -Djavac.source=1.6 -Djavac.target=1.6

%install
%mvn_file com.sun.pdfview:pdfrenderer %{name}
%mvn_artifact com.sun.pdfview:pdfrenderer:%{version} dist/%{alternate_name}.jar
%mvn_install -J dist/javadoc

# compat symlink (requected by @REAL); just let it be (but use pdf-renderer.jar, please!)
pushd %buildroot%_javadir
ln -s pdf-renderer.jar PDFRenderer.jar

%files -f .mfiles
%doc demos
%_javadir/PDFRenderer.jar

%files javadoc -f .mfiles-javadoc

# -----------------------------------------------------------------------------

%changelog
