Name: pdnsd
Version: 1.2.9a
Release: alt1

Summary: A caching DNS proxy for small networks and dialup users
License: %gpl3plus
Group: System/Servers

Url: http://members.home.nl/p.a.rombouts/pdnsd/

# git://git.altlinux.org/gears/p/pdnsd.git
Source: %name-%version-%release.tar

BuildPreReq: %_bindir/mksock
BuildPreReq: rpm-build-licenses >= 0.7

%description
pdnsd is a proxy DNS daemon with permanent disk cache and the ability
to serve local records.

%prep
%setup -n %name-%version-%release

mv alt/README.ALT .

%build
%autoreconf
%configure \
	--with-default-id=%name \
	--with-random-device=/dev/urandom
%make_build

%install
%make_install DESTDIR=%buildroot install
mkdir -p %buildroot{%_cachedir/%name,%_var/run/%name}
rm -f contrib/Makefile*

install -pD -m755 alt/%name.init %buildroot%_initdir/%name
install -pD -m755 alt/%name.conf %buildroot%_sysconfdir/%name.conf
install -pD -m755 alt/%name.ip-up %buildroot%_sysconfdir/ppp/ip-up.d/0%name
install -pD -m755 alt/%name.tmpfiles.d %buildroot%_tmpfilesdir/%name.conf

touch %buildroot%_cachedir/%name/%name.cache
mksock %buildroot%_var/run/%name/socket

bzip -9 ChangeLog

%files
%doc AUTHORS Change* COPYING.BSD NEWS README* THANKS TODO doc/pdnsd.conf contrib doc/txt doc/html
%_sbindir/%{name}*
%_mandir/man?/%{name}*
%_tmpfilesdir/%name.conf
%config %_initdir/%name
%config %_sysconfdir/ppp/ip-up.d/0%name
%config(noreplace) %_sysconfdir/%name.conf
	%attr(700,root,%name) %dir %_var/run/%name
%ghost	%attr(600,root,%name) %_var/run/%name/socket
	%attr(700,root,%name) %dir %_cachedir/%name
%ghost	%attr(600,root,%name) %verify(not md5 mtime size) %config(noreplace) %_cachedir/%name/%name.cache

%pre
%_sbindir/groupadd -r -f %name >/dev/null 2>&1 ||:
%_sbindir/useradd -r -g %name -d /dev/null -s /dev/null -n %name >/dev/null 2>&1 ||:

%post
[ -s %_cachedir/%name/%name.cache ] ||
        echo -n -e "pd12\0\0\0\0" >%_cachedir/%name/%name.cache
chmod 0600 %_cachedir/%name/%name.cache
chown root:%name %_cachedir/%name/%name.cache

%post_service %name

%preun
%preun_service %name

%changelog
