Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          pegdown
Version:       1.4.2
Release:       alt1_12jpp8
Summary:       Java library for Markdown processing
License:       ASL 2.0
URL:           http://pegdown.org
Source0:       https://github.com/sirthias/pegdown/archive/%{version}.tar.gz
# Newer release use sbt builder
Source1:       http://repo1.maven.org/maven2/org/pegdown/pegdown/%{version}/pegdown-%{version}.pom
# Forwarded upstream: https://github.com/sirthias/pegdown/pull/130
Patch0:        %{name}-rhbz1096735.patch

BuildRequires: maven-local
BuildRequires: mvn(net.sf.jtidy:jtidy)
BuildRequires: mvn(org.apache.felix:maven-bundle-plugin)
BuildRequires: mvn(org.parboiled:parboiled-java)
%if 0
# test deps
BuildRequires: mvn(org.specs2:specs2_2.9.3)
%endif

BuildArch:     noarch
Source44: import.info

%description
A pure-Java Markdown processor based on a parboiled PEG parser
supporting a number of extensions.

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.

%prep
%setup -q
find . -name "*.class" -delete
find . -name "*.jar" -delete
%patch0 -p1

cp -p %{SOURCE1} pom.xml

%pom_xpath_inject "pom:project" "
<build>
  <plugins>

  </plugins>
</build>"

%pom_xpath_inject "pom:build" "
<resources>
  <resource>
    <directory>.</directory>
    <targetPath>\${project.build.outputDirectory}/META-INF</targetPath>
    <includes>
      <include>LICENSE</include>
      <include>NOTICE</include>
    </includes>
  </resource>
</resources>"

%pom_add_plugin org.apache.maven.plugins:maven-jar-plugin . "
<configuration>
  <archive>
    <manifestFile>\${project.build.outputDirectory}/META-INF/MANIFEST.MF</manifestFile>
    <manifest>
      <addDefaultImplementationEntries>true</addDefaultImplementationEntries>
      <addDefaultSpecificationEntries>true</addDefaultSpecificationEntries>
    </manifest>
  </archive>
</configuration>"

%pom_add_plugin org.apache.felix:maven-bundle-plugin . "
<extensions>true</extensions>
<configuration>
  <instructions>
    <Built-By>\${user.name}</Built-By>
    <Bundle-SymbolicName>org.pegdown</Bundle-SymbolicName>
    <Bundle-Name>pegdown</Bundle-Name>
    <Bundle-Vendor>pegdown.org</Bundle-Vendor>
    <Bundle-Version>\${project.version}</Bundle-Version>
  </instructions>
</configuration>
<executions>
  <execution>
    <id>bundle-manifest</id>
    <phase>process-classes</phase>
    <goals>
      <goal>manifest</goal>
    </goals>
  </execution>
</executions>"

rm -r src/test/scala/*
%pom_remove_dep org.specs2:specs2_2.9.3

%mvn_file :%{name} %{name}

%build

%mvn_build -- -Dproject.build.sourceEncoding=UTF-8

%install
%mvn_install

%files -f .mfiles
%doc CHANGELOG README.markdown
%doc --no-dereference LICENSE NOTICE

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENSE NOTICE

%changelog
