# hasher :(
# network is required to query example.com
%define _without_test 1

%define module Mail-SPF

Name: perl-%module
Version: 2.9.0
Release: alt2

Summary: Perl module that implements Sender Policy Framework
License: BSD
Group: Development/Perl

URL: %CPAN %module
Source: http://www.cpan.org/authors/id/J/JM/JMEHNLE/mail-spf/Mail-SPF-v%{version}.tar.gz

Patch0:         Mail-SPF-v2.8.0-POD.patch
# https://rt.cpan.org/Public/Bug/Display.html?id=78214
Patch1:         Mail-SPF-v2.8.0-testsuite.patch



BuildArch: noarch

# Automatically added by buildreq on Sun Mar 25 2012
BuildRequires: perl-Error perl-Mail-SPF-Test perl-Module-Build perl-Net-DNS-Resolver-Programmable perl-Test-Pod perl-URI

%description
Mail::SPF is an object-oriented Perl implementation of the Sender Policy
Framework (SPF) e-mail sender authentication system.

%prep
%setup -n %module-v%version
# Fix broken POD (CPAN RT#86060)
%patch0
# Work around test suite failures with Net::DNS ≥ 0.68 (CPAN RT#78214)
%patch1
rm t/90-author-pod-validation.t

%build
%perl_vendor_build

%install
%perl_vendor_install

# For now we exclude spfquery and spfd in favor of perl-Mail-SPF-Query.
# Will change this later?

%files
%exclude %_bindir/spfquery
%exclude %_sbindir/spfd
%exclude %_man1dir/spf*
%perl_vendor_privlib/Mail/SPF*

%changelog
