# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(threads.pm) perl(threads/shared.pm) perl-pod perl-podlators perldoc
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Net-Jabber
Version:        2.0
Release:        alt3_34
Summary:        Net::Jabber - Jabber Perl Library
Group:          Development/Other
License:        (GPL+ or Artistic) or LGPLv2+
URL:            https://metacpan.org/release/Net-Jabber
Source0: https://cpan.metacpan.org/authors/id/R/RE/REATMON/Net-Jabber-%{version}.tar.gz
Source1:        LICENSING.correspondance
Patch0:         Net-Jabber-2.0-timezone.patch
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(Net/XMPP.pm)
BuildRequires:  perl(Net/XMPP/Client.pm)
BuildRequires:  perl(Net/XMPP/Connection.pm)
BuildRequires:  perl(Net/XMPP/Debug.pm)
BuildRequires:  perl(Net/XMPP/IQ.pm)
BuildRequires:  perl(Net/XMPP/JID.pm)
BuildRequires:  perl(Net/XMPP/Message.pm)
BuildRequires:  perl(Net/XMPP/Namespaces.pm)
BuildRequires:  perl(Net/XMPP/Presence.pm)
BuildRequires:  perl(Net/XMPP/Stanza.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Time/Timezone.pm)
# file requires for prep
BuildRequires:  %{_bindir}/perldoc
Requires:  perl(Time/Timezone.pm)
Source44: import.info

%description
Net::Jabber provides a Perl user with access to the Jabber Instant
Messaging protocol.

For more information about Jabber visit:

    http://www.jabber.org

%prep
%setup -q -n Net-Jabber-%{version}
%patch0 -p1
cp %{SOURCE1} .
# generate our other two licenses...
perldoc perlgpl > LICENSE.GPL
perldoc perlartistic > LICENSE.Artistic
# we really don't want executable examples...
chmod -x examples/*

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="%{optflags}"
%make_build

%install
make pure_install PERL_INSTALL_ROOT=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} ';'
find %{buildroot} -type f -name '*.bs' -a -size 0 -exec rm -f {} ';'
find %{buildroot} -type d -depth -exec rmdir {} 2>/dev/null ';'
chmod -R u+w %{buildroot}/*
# fix wonky execute permissions
find %{buildroot} -type f -exec chmod -x '{}' ';'

%check
# Disable tests which will fail under mock
rm t/protocol_definenamespace.t
rm t/protocol_muc.t
rm t/protocol_rpc.t
make test

%files
%doc CHANGES README examples LICENSE.* LICENSING.*
%{perl_vendor_privlib}/*

%changelog
