Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Sub/Uplevel.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Scope-Upper
Summary:        Act on upper scopes
Version:        0.31
Release:        alt2_1
License:        GPL+ or Artistic
Source0:        https://cpan.metacpan.org/authors/id/V/VP/VPIT/Scope-Upper-%{version}.tar.gz
URL:            https://metacpan.org/release/Scope-Upper
# Build
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  sed
# Runtime
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(XSLoader.pm)
# Tests only
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(feature.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(POSIX.pm)
# It's either Scalar::Util or B; with the former being preferred
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(threads.pm)
BuildRequires:  perl(threads/shared.pm)
# Optional tests only
BuildRequires:  perl(Time/HiRes.pm)
Requires:       perl(Exporter.pm)
Requires:       perl(XSLoader.pm)


Source44: import.info

%description
This module lets you defer actions that will take place when the control
flow returns into an upper scope. Currently, you can hook an upper scope
end, or localize variables, array/hash values or deletions of elements
in higher contexts. You can also return to an upper level and know which
context was in use then.

%prep
%setup -q -n Scope-Upper-%{version}
sed -i -e '1s,^#!.*perl,%(perl -MConfig -e 'print $Config{startperl}'),' \
    samples/*

%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="%{optflags}" NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name '*.bs' -a -size 0 -delete
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc README Changes samples
%{perl_vendor_archlib}/*
%exclude %dir %{perl_vendor_archlib}/auto

%changelog
