%define		php7_extension	opcache

Name:	 	php7-%php7_extension
Version:	%php7_version
Release:	%php7_release.3

Summary:	Zend Opcache extension for opcode caching and optimization

Group:		System/Servers
License:	PHP-3.01
URL:		http://php.net/manual/en/book.opcache.php
#		http://pecl.php.net/package/ZendOpcache

Packager:       Nikolay A. Fetisov <naf@altlinux.org>

#Source0:	standart PHP module
Source1:	php-%php7_extension.ini
Source2:	php-%php7_extension-params.sh

Patch0: php7-opcache-sapi-names.patch
Patch1: php7-opcache-file_cache.patch

BuildRequires(pre): rpm-build-php7
BuildRequires: gcc-c++
BuildRequires: php7-devel = %php7_version
BuildRequires: php7 = %php7_version


%description
php7 Opcache extension provides faster PHP execution through
opcode caching and optimization. It improves PHP performance
by storing precompiled script bytecode in the shared memory.
This eliminates the stages of reading code from the disk and
compiling it on future access. In addition, it applies a few
bytecode optimization patterns that make code execution
faster.

%prep
%setup -T -c
cp -pr -- %php7_extsrcdir/%php7_extension/* .

%patch0
%patch1


%build
phpize

%ifarch %e2k
%add_optflags -U__AVX__ -U__SSE2__
%endif

%configure \
	--with-libdir=%_lib \
	--enable-%php7_extension \
	--enable-%php7_extension-file \
	%nil

%php7_make

%install
%php7_make_install
install -D -m 644 -- %SOURCE1 %buildroot/%php7_extconf/%php7_extension/config
install -D -m 644 -- %SOURCE2 %buildroot/%php7_extconf/%php7_extension/params

%check
NO_INTERACTION=1 make test

%files
%php7_extconf/%php7_extension
%php7_extdir/*

%post
%php7_extension_postin

%preun
%php7_extension_preun

%changelog
