%define		php7_extension	openssl

Name:	 	php7-%php7_extension
Version:	%php7_version
Release:	%php7_release.1

Summary:	OpenSSL module for php7
Group:		System/Servers
License:	PHP-3.01

Source1:	php-%php7_extension.ini
Source2:	php-%php7_extension-params.sh

BuildRequires(pre): rpm-build-php7
BuildRequires:	php7-devel = %php7_version

BuildRequires: libssl-devel pkgconfig
# for tests
BuildRequires: php7 /proc

%description
This module uses the functions of OpenSSL for generation and verification 
of signatures and for sealing (encrypting) and opening (decrypting) data. 
OpenSSL offers many features that this module currently doesn't support. 
Some of these may be added in the future.

%prep
%setup -T -c
cp -pr %php7_extsrcdir/%php7_extension/* .

# simple fix
mv config0.m4 config.m4

%build
phpize7

BUILD_HAVE=`echo %php7_extension | tr '[:lower:]-' '[:upper:]_'`
%add_optflags -fPIC -L%_libdir
export LDFLAGS=-lphp-%_php7_version
%configure \
	--with-%php7_extension=%_usr \
	--with-libdir=%_lib \
	#
%php7_make

%check
make test

%install
%php7_make_install
install -D -m 644 %SOURCE1 %buildroot/%php7_extconf/%php7_extension/config
install -D -m 644 %SOURCE2 %buildroot/%php7_extconf/%php7_extension/params

%files
%php7_extconf/%php7_extension
%php7_extdir/*
%doc CREDITS

%post
%php7_extension_postin

%preun
%php7_extension_preun

%changelog
