%define ver_major 0.11
%def_enable dbusmenu
%def_disable apport

Name: plank
Version: %ver_major.4
Release: alt1

Summary: Elegant, simple, clean dock
License: GPLv3+
Group: Graphical desktop/Other
Url: https://launchpad.net/plank

Source: https://launchpad.net/%name/1.0/%version/+download/%name-%version.tar.xz

Requires: bamfdaemon dconf

%define gtk_ver 3.10
%define glib_ver 2.40
%define bamf_ver 0.2.92

BuildRequires: intltool xmllint help2man
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libbamf3-devel >= %bamf_ver libgee0.8-devel
BuildRequires: libwnck3-devel libXi-devel libXfixes-devel
BuildRequires: xvfb-run dbus-tools-gui
BuildRequires: vala-tools
%{?_enable_dbusmenu:BuildRequires: libdbusmenu-gtk3-devel}

%description
Plank is a dock enabling you to start applications and manage your windows.

%package -n lib%name
Summary: Library to build a elegant, simple, clean dock
Group: System/Libraries

Requires: lib%name-common = %version-%release

%description -n lib%name
Plank is a dock enabling you to start applications and manage your windows.

%package -n lib%name-devel
Summary: Library to build a elegant, simple, clean dock (development files)
Group: Development/C

%description -n lib%name-devel
Plank is a dock enabling you to start applications and manage your windows.

%package -n lib%name-common
Summary: Library to build a elegant, simple, clean dock
Group: Graphical desktop/Other
BuildArch: noarch

# TODO:
# Depends: plank-theme-pantheon

%description -n lib%name-common
Plank is a dock enabling you to start applications and manage your windows.

%package -n lib%name-doc
Summary: Library to build a elegant, simple, clean dock - documentation
Group: Documentation
BuildArch: noarch
Conflicts: lib%name < %version

%description -n lib%name-doc
Plank is a dock enabling you to start applications and manage your windows.

This package contains the documentation.

%package -n lib%name-vala
Summary: Vala language bindings for plank library
Group: Development/Other
BuildArch: noarch
Requires: lib%name = %version-%release

%description -n lib%name-vala
This package provides Vala language bindings for plank library.

%prep
%setup

%build
%autoreconf
%configure \
  --enable-headless-tests \
  %{subst_enable dbusmenu} \
  %{subst_enable apport}
%make_build

%install
%makeinstall_std

%find_lang %name

%check
#make check || exit 1


%files -f %name.lang
%_bindir/%name
%_datadir/icons/hicolor/*/apps/plank.*
%_man1dir/plank.*
%_desktopdir/plank.desktop
%dir %_libdir/plank
%dir %_libdir/plank/docklets
%_libdir/plank/docklets/libdocklet-clippy.so
%_libdir/plank/docklets/libdocklet-clock.so
%_libdir/plank/docklets/libdocklet-cpumonitor.so
%_libdir/plank/docklets/libdocklet-desktop.so
%_libdir/plank/docklets/libdocklet-trash.so
%_datadir/glib-2.0/schemas/net.launchpad.plank.gschema.xml
%_datadir/appdata/plank.appdata.xml

%if_enabled apport
%_sysconfdir/apport/crashdb.conf.d/plank-crashdb.conf
%_datadir/apport/package-hooks/source_plank.py
%endif

%exclude %_libdir/plank/docklets/*.la

%files -n lib%name
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_libdir/lib%name.so
%_includedir/plank
%_pkgconfigdir/plank.pc

%files -n lib%name-common
%_datadir/plank/themes

%files -n lib%name-doc

%files -n lib%name-vala
%_datadir/vala/vapi/plank.deps
%_datadir/vala/vapi/plank.vapi

%changelog
