# system bus required
%def_disable check

Name: polkit
Version: 0.116
Release: alt2.M90P.4

Summary: PolicyKit Authorization Framework
License: LGPLv2+
Group: System/Libraries
URL: http://www.freedesktop.org/wiki/Software/PolicyKit
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: lib%name = %version-%release
Requires(pre): dbus

Source: %name-%version.tar
Patch: %name-%version-%release.patch
Patch1: %name-0.109-alt-helper_path.patch

BuildRequires: gcc-c++ gobject-introspection-devel gtk-doc intltool libexpat-devel libpam-devel
BuildRequires: libmozjs60-devel libsystemd-devel
%{?_enable_check:BuildRequires: /proc dbus-tools-gui}

%description
PolicyKit is a toolkit for defining and handling authorizations.
It is used for allowing unprivileged processes to speak to privileged
processes.

%package -n lib%name
Summary: PolicyKit libraries
Group: System/Libraries
Provides: lib%{name}1 = %version-%release
Obsoletes: lib%{name}1 < %version

%description -n lib%name
Libraries for interacting with PolicyKit

%package -n lib%name-devel
Summary: Development libraries and headers for PolicyKit
Group: Development/C
Requires: lib%name = %version-%release
Provides: lib%{name}1-devel = %version-%release
Obsoletes: lib%{name}1-devel < %version

%description -n lib%name-devel
Headers, libraries and API docs for PolicyKit

%package -n lib%name-gir
Summary: GObject introspection data for the Polkit-1.0 library
Group: System/Libraries
Requires: lib%name = %version-%release
Provides: lib%{name}1-gir = %version-%release
Obsoletes: lib%{name}1-gir < %version

%description -n lib%name-gir
GObject introspection data for the Polkit-1.0 library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Polkit-1.0 library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release lib%name-devel = %version-%release
Provides: lib%{name}1-gir-devel = %version-%release
Obsoletes: lib%{name}1-gir-devel < %version

%description -n lib%name-gir-devel
GObject introspection devel data for the Polkit-1.0 library

%prep
%setup
%patch -p1
%patch1 -p1

touch ChangeLog

%build
%ifarch %e2k
%add_optflags -std=gnu++11
%endif
%autoreconf
%configure \
	--libexecdir=%_prefix/libexec \
	--localstatedir=%_var \
	--enable-gtk-doc \
	--disable-static \
	--enable-libsystemd-login=yes
%make

%install
%makeinstall_std

%find_lang %name-1

%check
%make check

%pre
%_sbindir/groupadd -r -f polkitd 2>/dev/null ||:
%_sbindir/useradd -r -n -g polkitd -d / \
	-s /dev/null -c "User for polkitd" polkitd 2>/dev/null ||:

%files -f %name-1.lang
%dir %_sysconfdir/%name-1
%attr(0700,polkitd,root) %dir %_sysconfdir/%name-1/rules.d
%_sysconfdir/%name-1/rules.d/50-default.rules
%_datadir/dbus-1/system.d/org.freedesktop.PolicyKit1.conf
%_sysconfdir/pam.d/polkit-1
%_bindir/pk[act]*
%attr(4511,root,root) %_bindir/pkexec
%dir %_prefix/libexec/%name-1
%_prefix/libexec/%name-1/polkitd
%attr(4511,root,root) %_prefix/libexec/polkit-1/polkit-agent-helper-1
%dir %_datadir/%name-1
%dir %_datadir/%name-1/actions
%attr(0700,polkitd,root) %dir %_datadir/%name-1/rules.d
%_datadir/%name-1/actions/org.freedesktop.policykit.policy
%_datadir/dbus-1/system-services/org.freedesktop.PolicyKit1.service
%systemd_unitdir/polkit.service
%_man1dir/*.1*
%_man8dir/*.8*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-gir
%_typelibdir/*.typelib

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/gettext/its/%name.its
%_datadir/gettext/its/%name.loc
%_datadir/gtk-doc/html/%name-1/

%files -n lib%name-gir-devel
%_girdir/*.gir

# examples
%exclude %_bindir/pk-example-frobnicate
%exclude %_datadir/polkit-1/actions/org.freedesktop.policykit.examples.pkexec.policy

%changelog
