%define pg_ver 12

Name: postgis
Version: 3.1.1
Release: alt0.p9.1

Summary: Geographic Information Systems Extensions to PostgreSQL
Summary(ru_RU.UTF-8): Геоинформационные расширения для PostgreSQL
License: GPL-2.0
Group: Databases
Url: http://postgis.refractions.net

Source: %name-%version.tar
Source1: create_template_postgis
Source2: postgis.watch

BuildRequires: gcc-c++
BuildRequires: ImageMagick-tools
BuildRequires: docbook-dtds
BuildRequires: docbook-style-xsl
BuildRequires: flex
BuildRequires: libgdal-devel
BuildRequires: libgeos-devel
BuildRequires: libgtk+2-devel
BuildRequires: libproj-devel
BuildRequires: libxml2-devel
BuildRequires: postgresql-devel
BuildRequires: libjson-c-devel
BuildRequires: libprotobuf-c-devel
BuildRequires: protobuf-c-compiler
BuildRequires: libpcre-devel
BuildRequires: xsltproc

Requires: postgresql%pg_ver-%name = %EVR

%description
PostGIS adds support for geographic objects to the PostgreSQL
object-relational database. In effect, PostGIS "spatially enables" the
PostgreSQL server, allowing it to be used as a backend spatial
database for geographic information systems (GIS).

%description -l ru_RU.UTF-8
PostGIS добавляет поддержку географических объектов в PostgreSQL. В
сущности PostGIS является расширением PostgreSQL сервера,
позволяющим использовать его для хранения и обработки геоданных в
геоинформационных системах (ГИС).

%package -n postgresql%pg_ver-%name
Summary: The PostGIS extension for PostgreSQL
Group: Databases
Requires: postgresql%pg_ver-server

%description -n postgresql%pg_ver-%name
This package contains shared library for PostgreSQL server

%description -n postgresql%pg_ver-%name -l ru_RU.UTF-8
Подгружаемая postgis библиотека для PostgreSQL сервера

%prep
%setup
subst "s|PGSQL_DOCDIR|DOCDIR|g" doc/Makefile.in

%build
export PCRE_CPPFLAGS=-I/usr/include/pcre
./autogen.sh
%configure \
	--disable-static \
	--with-gui \
	--with-raster \
	--with-xsldir=%_datadir/xml/docbook/xsl-stylesheets
%make all docs comments

%install
install -pD -m0755 %SOURCE1 %buildroot%_bindir/create_template_postgis
install -d %buildroot%_libdir/pgsql/
install -d %buildroot%_includedir
%makeinstall_std
%makeinstall_std -C doc docs-install comments-install man-install DOCDIR=%_docdir/%name-%version

rm -rf %buildroot%_libdir/liblwgeom.a

%files
%doc %_docdir/%name-%version
%_bindir/pgsql2shp
%_bindir/shp2pgsql*
%_bindir/raster2pgsql
%_man1dir/*
%_datadir/pgsql/applications/shp2pgsql-gui.desktop
%_datadir/pgsql/icons/hicolor/*/apps/shp2pgsql-gui.png

%files -n postgresql%pg_ver-%name
%_bindir/create_template_postgis
%_libdir/pgsql/%{name}*.so
%_libdir/pgsql/address_standardizer*.so
%_datadir/pgsql/contrib/postgis-*/*.sql
%_datadir/pgsql/contrib/postgis-*/*.pl
%_datadir/pgsql/extension
%doc %_datadir/doc/postgresql/extension/README.address_standardizer

%changelog
