Name: powertop
Version: 2.13
Release: alt1
Epoch: 1

Summary: Tool that helps you find what software is using the most power
License: GPLv2
Group: System/Kernel and hardware

Url: https://01.org/powertop/
Source0: %name-%version.tar
Source1: %name.service
Source2: %name.init
Source100: %name.watch

# Automatically added by buildreq on Tue May 15 2012
# optimized out: libncurses-devel libstdc++-devel libtinfo-devel pkg-config xz
BuildRequires: gcc-c++ libncursesw-devel libnl-devel libpci-devel zlib-devel
BuildRequires: autoconf-archive

%define cachedir %_cachedir/%name

%description
PowerTOP is a Linux tool that finds the software component(s) that make
your laptop use more power than necessary while it is idle.

PowerTOP works best on a laptop computer, or at least a computer with an
Intel mobile processor (certain small non-laptop devices also contain a
mobile processor). When using PowerTOP on a laptop, do so when running
on battery.

Please note that it also runs just fine with e.g. AMD CPUs. :)

%prep
%setup

%build
./autogen.sh
%configure
%make_build

%install
%makeinstall_std
%find_lang %name
install -d %buildroot%cachedir
touch %buildroot%cachedir/saved_{parameters,results}.powertop
install -pDm644 %SOURCE1 %buildroot%_unitdir/%name.service
install -pDm755 %SOURCE2 %buildroot%_initdir/%name

%post
%post_service %name
# Hack for powertop not to show warnings on first start
touch %cachedir/saved_{parameters,results}.powertop

%preun
%preun_service %name

%files -f %name.lang
%_sbindir/*
%_datadir/bash-completion
%_man8dir/*
%doc README.md
%dir %cachedir
%ghost %cachedir/saved_*.powertop
%_unitdir/%name.service
%_initdir/%name

%changelog
