%def_disable static

%def_with pam
%def_with cbcp
%def_with chapms
%def_with mppe
%def_with libatm
%def_with inet6
%def_with systemd
# https://bugzilla.redhat.com/1556132
%def_without crypt

Name: ppp
Version: 2.4.7
Release: alt6

Summary: The PPP daemon and documentation
License: distributable
Group: System/Servers

Url: http://ppp.samba.org

Source0: %name-%version.tar
Source2: ppp.pamd
Source4: ppp.control
Source5: ppp.logrotate
Source6: ppp.tmpfiles
Source7: 95-ppp.rules

# eaptls and openssl need manual conflict resolution
# TODO: %%def_with'ize those?
Patch1: %name-%version-%release.patch

PreReq: %_lockdir/serial
Obsoletes: ppp-cbcp, ppp-mppe
Obsoletes: ppp-extra

BuildRequires: libpam-devel libpcap-devel libssl-devel perl-IPC-Signal perl-Proc-Daemon perl-Proc-WaitStat libudev-devel
%{?_with_libatm:BuildRequires: libatm-devel}
%{?_with_systemd:BuildRequires: libsystemd-devel}
Requires: ppp-common libssl
Requires: kmod >= 14
Requires: udev >= 204-alt2


%add_findprov_lib_path %_libdir/pppd/%version


%package devel
Summary: Header files needed for building extra pppd plugins
Group: Development/C
Requires: %name = %version-%release
BuildArch: noarch

%package radius
Summary: RADIUS authentication plugin for pppd
Group: System/Servers
Requires: %name = %version-%release

%package pppoatm
Summary: PPP over ATM plugin for pppd
Group: System/Servers
Requires: %name = %version-%release


%package pppoe
Summary: PPP over ethernet plugin for pppd
Group: System/Servers
Requires: %name = %version-%release

%package dhcp
Summary: DHCP plugin for %{name}
Group: System/Servers
Requires: %name = %version-%release

%description
The %name package contains the PPP (Point-to-Point Protocol) daemon
and documentation for PPP support.  The PPP protocol provides a
method for transmitting datagrams over serial point-to-point links.

The %name package should be installed if your machine need to support
the PPP protocol.

%description devel
Header files needed for building extra pppd plugins.

%description radius
The Remote Authentication Dial In User Service (RADIUS) plugin for pppd
permits pppd to perform PAP, CHAP, MS-CHAP and MS-CHAPv2 authentication
against a RADIUS server instead of the usual /etc/ppp/pap-secrets and
/etc/ppp/chap-secrets files.

%description pppoatm
PPP over ATM plugin for pppd.

%description pppoe
PPP over ethernet plugin for pppd.

%description    dhcp
DHCP plugin for pppd.


%prep
%setup
%patch1 -p1

#set the right paths in radiusclient.conf
sed -i -e "s|/usr/local/etc|%_sysconfdir|" \
	     -e "s|/usr/local/sbin|%_sbindir|" pppd/plugins/radius/etc/radiusclient.conf
#set config dir to /etc/ppp/radius
sed -i -e "s|/etc/radiusclient|/etc/ppp/radius|g" \
		pppd/plugins/radius/{*.8,*.c,*.h} \
		pppd/plugins/radius/etc/*

find -type f -name \*.orig -print -delete
rm -f include/linux/if_pppol2tp.h

%build
%add_optflags -fPIC -Wall -D_GNU_SOURCE -fno-strict-aliasing
%configure
%make_build %{?_with_pam:USE_PAM=y} \
	    %{?_with_cbcp:CBCP=y} \
	    %{?_with_chapms:CHAPMS=y} \
	    %{?_with_crypt:USE_CRYPT=y} \
	    %{?_with_mppe:MPPE=y} \
	    %{?_with_libatm:HAVE_LIBATM=y} \
	    %{?_with_inet6:HAVE_INET6=y} \
	    %{?_with_systemd:SYSTEMD=y} \
	    COPTS="%optflags" \
	    CC="gcc" \
	    libdir=%_libdir

%install
%make_install install 	DESTDIR=%buildroot \
			BINDIR=%buildroot%_sbindir \
			INCDIR=%buildroot%_includedir \
			libdir=%_libdir \
			MANDIR=%buildroot%_man8dir \
			RUNDIR=%buildroot%_var/run/ppp \
			LOGDIR=%buildroot%_logdir/ppp
%make_install install-etcppp INSTROOT=%buildroot \
			ETCDIR=%buildroot%_sysconfdir/%name

for f in `find scripts/ sample/ -type f`; do
	chmod 644 "$f"
	if fgrep -qs /usr/local/bin/ "$f"; then
		subst -p 's|/usr/local/bin|%_bindir|g' "$f"
	fi
	if file -b "$f" |fgrep -qs 'shell script'; then
		chmod a+x "$f"
	fi
done

install -pDm640 %SOURCE2 %buildroot%_sysconfdir/pam.d/%name

mkdir -p %buildroot%_sysconfdir/%name/peers
install -pm600 sample/callback-* %buildroot%_sysconfdir/%name/

mkdir -p %buildroot%_sysconfdir/%name/radius
cp -a pppd/plugins/radius/etc/* %buildroot%_sysconfdir/%name/radius/

install -pDm755 %SOURCE4 %buildroot%_controldir/%name

# Provide pointers for people who expect stuff in old places
mkdir -p %buildroot{%_logdir,%_var/run}/%name
touch %buildroot%_logdir/%name/connect-errors
touch %buildroot%_var/run/%name/resolv.conf

ln -s ../..%_logdir/%name/connect-errors %buildroot%_sysconfdir/%name/connect-errors
ln -s ../..%_var/run/%name/resolv.conf %buildroot%_sysconfdir/%name/resolv.conf

install -pDm644 %SOURCE6 %buildroot/%_tmpfilesdir/%name.conf
install -pDm644 %SOURCE7 %buildroot/%_udevrulesdir/95-%name.rules

# Logrotate script
install -pDm644 %SOURCE5 %buildroot%_sysconfdir/logrotate.d/%name

# Install EAP-TLS config examples
install -pm600 etc.ppp/openssl.cnf %buildroot%_sysconfdir/%name/openssl.cnf

%pre
%pre_control %name

%post
%post_control -s traditional %name

%files
%attr(711,root,root) %_sbindir/*
%exclude %_sbindir/pppoe-discovery
%attr(700,root,root) %dir %_logdir/%name
%attr(755,root,root) %dir %_sysconfdir/%name
%attr(711,root,root) %dir %_sysconfdir/%name/peers
%attr(600,root,root) %config(noreplace) %_sysconfdir/%name/*-secrets
%attr(600,root,root) %config(noreplace) %_sysconfdir/%name/eaptls-*
%attr(600,root,root) %config(noreplace) %_sysconfdir/%name/openssl*
%attr(750,root,root) %config(noreplace) %_sysconfdir/%name/callback-*
%attr(644,root,root) %config(noreplace) %_sysconfdir/%name/options
%attr(600,root,root) %_sysconfdir/%name/connect-errors
%attr(644,root,root) %_sysconfdir/%name/resolv.conf
%config(noreplace) %_sysconfdir/logrotate.d/%name
%config(noreplace) %_sysconfdir/pam.d/%name
%_tmpfilesdir/%name.conf
%_udevrulesdir/95-%name.rules
%config %_controldir/%name
%_libdir/pppd
%_var/run/%name
%_logdir/%name/*
%{?_with_libatm:%exclude %_libdir/pppd/%version/pppoatm.so}
%exclude %_libdir/pppd/%version/rp-pppoe.so
%exclude %_libdir/pppd/%version/rad*
%exclude %_libdir/pppd/%version/dhcpc.so
%_man8dir/*.8*
%exclude %_man8dir/*rad*
%exclude %_man8dir/pppoe-discovery*
%doc PLUGINS SETUP FAQ README* scripts sample

%files devel
%_includedir/pppd

%if_with libatm
%files pppoatm
%_libdir/pppd/%version/pppoatm.so
%endif

%files pppoe
%_libdir/pppd/%version/rp-pppoe.so
%attr(755,root,root) %_sbindir/pppoe-discovery
%_man8dir/pppoe-discovery*

%files radius
%_libdir/pppd/%version/rad*.so
%_man8dir/*rad*
%config(noreplace) %_sysconfdir/%name/radius/

%files dhcp
%doc pppd/plugins/dhcp/README
%doc pppd/plugins/dhcp/AUTHORS
%doc pppd/plugins/dhcp/COPYING
%_libdir/pppd/%version/dhcpc.so

%changelog
