%define ppp_ver %((%{__awk} '/^#define VERSION/ { print $NF }' /usr/include/pppd/patchlevel.h 2>/dev/null||echo none)|/usr/bin/tr -d '"')

%def_enable bcrelay

Name: pptpd
Version: 1.4.0
Release: alt3

Summary: A PPTP server daemon
License: GPLv2+ and LGPLv2+
Group: System/Servers

Url: http://www.poptop.org

#http://heanet.dl.sourceforge.net/sourceforge/poptop/%name-%version.tar.gz
Source: %name-%version.tar
Source1: pptpd.init
Source2: pptpd.sysconfig
Source3: pptpd.service

Patch: %name-%version-%release.patch

Requires: ppp = %ppp_ver

BuildRequires: ppp-devel

#%%def_with libwrap

%description
PPTPd, Point-to-Point Tunnelling Protocol Daemon, offers out connections
to PPTP clients to become virtual members of the IP pool owned by the PPTP
server.  In effect, these clients become virtual members of the local
subnet, regardless of what their real IP address is.  A tunnel is built
between the PPTP server and client, and packets from the subnet are
wrapped and passed between server and client similar to other C/S
protocols.

%prep
%setup -q
%patch -p1

%build

# dirty hack for fix wtmp work on x86_64
sed -i -e "s,/usr/lib/pptpd,%_libdir/pptpd,g" pptpctrl.c

%autoreconf
%configure \
	%{subst_enable bcrelay}

%make_build

%install
%makeinstall

install -pD -m644 samples/%name.conf %buildroot%_sysconfdir/%name.conf
install -pD -m644 samples/options.%name %buildroot%_sysconfdir/ppp/options.%name
install -pD -m755 %SOURCE1 %buildroot%_initdir/%name
install -pD -m600 %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name
install -pD -m644 %SOURCE3 %buildroot%_unitdir/%name.service

%post
%post_service %name

%preun
%preun_service %name

%files
%_initdir/%name
%_unitdir/%name.service
%config(noreplace) %_sysconfdir/sysconfig/%name
%config(noreplace) %_sysconfdir/%name.conf
%config(noreplace) %_sysconfdir/ppp/options.%name
%_sbindir/*
%_mandir/man?/*
%_libdir/%name
%doc AUTHORS NEWS README* TODO samples tools ChangeLog* html

%changelog
