Name: procmail
Version: 3.22
Release: alt10

Summary: The procmail mail processing program
License: GPLv2+ or Artistic
Group: Networking/Mail
#Url: http://www.procmail.org
Url: https://en.wikipedia.org/wiki/Procmail

# ftp://ftp.procmail.org/pub/procmail/procmail-%version.tar.gz
Source: procmail-%version.tar
Source1: README.Maildir
Source2: mailstat.1

Patch1: procmail-3.22-deb-fixes.patch
Patch2: procmail-3.22-owl-alt-fixes.patch
Patch3: procmail-3.22-owl-alt-config.patch
Patch4: procmail-3.22-deb-alt-doc.patch
Patch5: procmail-3.22-deb-355472-doc-procmailex.patch
Patch6: procmail-3.22-deb-151627-formail.patch
Patch7: procmail-3.22-deb-474298-484352-mailfold.patch
Patch8: procmail-3.22-owl-truncate.patch
Patch9: procmail-3.22-deb-337048-mailstat.patch
Patch10: procmail-3.22-deb-452723-doc-procmailrc.patch
Patch11: procmail-3.22-taviso-bound-CVE-2014-3618.patch
Patch12: procmail-3.22-deb-771958-bound.patch
Patch13: procmail-3.22-deb-769937-formail-bound.patch
Patch14: procmail-3.22-deb-876511-formail-bound-CVE-2017-16844.patch
Patch15: procmail-3.22-rh-formail-uninitialized.patch

Provides: MDA
# This procmail requires useradd with mailspool support installed.
Requires: shadow-utils >= 0:20000902-alt3

# Automatically added by buildreq on Tue May 15 2001
BuildRequires: sendmail-common

%description
procmail is a mail processing program which can be used to filter,
sort, or selectively forward e-mail messages.  Also, procmail is
installed by default as the local delivery agent.

%prep
%setup
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1

find -type f -name \*.orig -delete

find -type f -print0 |
	xargs -r0 grep -FZl /usr/ucb/mail -- |
	xargs -r0 sed -i 's|/usr/ucb/mail|/bin/mail|g' --

find -type f -print0 |
	xargs -r0 grep -FZl getline -- |
	xargs -r0 sed -i 's/getline/get_line/g' --

sed -i 's,\(/usr\)\(/spool\)\?/mail,/var\2/mail,g' examples/advanced FAQ

# Remove binmail from manpages.
sed -i /binmail/d man/*.man

install -pm644 %_sourcedir/README.Maildir .
xz -9k HISTORY

%build
%make_build \
	CC=%__cc \
	CFLAGS0="%optflags -fpie -fno-strict-aliasing -Wno-comment -Wno-parentheses -Wno-unused `getconf LFS_CFLAGS`" \
	LDFLAGS0='-pie -Wl,-z,relro,-z,now' \
	LOCKINGTEST=100 \
	SEARCHLIBS=-lm \
	#

%install
mkdir -p %buildroot{%_bindir,%_mandir/man{1,5}}
%make_install install \
        BASENAME=%buildroot%_prefix \
        MANDIR=%buildroot%_mandir

install -pm644 %_sourcedir/mailstat.1 %buildroot%_man1dir/

%files
%_bindir/*
%_mandir/man?/*
%doc Artistic FAQ FEATURES HISTORY.xz KNOWN_BUGS README README.Maildir examples

%changelog
