Group: Development/Java
# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
BuildRequires: /proc
BuildRequires: jpackage-generic-compat
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global git_commit 659fc71

Summary:       Java connection pool library
Name:          proxool
Version:       0.9.1
Release:       alt2_21jpp8
Epoch:         0
License:       ASL 2.0
URL:           http://proxool.sourceforge.net/
# Grabbing a newer version from git due to license change
# https://github.com/proxool/proxool/tarball/master
# (commit 659fc71e617151327779802a5171f0da8205918d)
Source0:       proxool-proxool-%{git_commit}.tar.gz
Source1:       proxool.pom
Patch0:        proxool-no-embedded-cglib.patch

BuildRequires: ant >= 0:1.7.1
BuildRequires: ant-junit
BuildRequires: java-devel >= 1.6.0
BuildRequires: javapackages-local
BuildRequires: mvn(avalon-framework:avalon-framework-api)
BuildRequires: mvn(avalon-framework:avalon-framework-impl)
BuildRequires: mvn(avalon-logkit:avalon-logkit)
BuildRequires: mvn(com.puppycrawl.tools:checkstyle)
BuildRequires: mvn(commons-collections:commons-collections)
BuildRequires: mvn(commons-lang:commons-lang)
BuildRequires: mvn(commons-logging:commons-logging)
BuildRequires: mvn(dom4j:dom4j)
BuildRequires: mvn(hsqldb:hsqldb:1)
BuildRequires: mvn(javax.servlet:javax.servlet-api)
BuildRequires: mvn(javax.transaction:jta)
BuildRequires: mvn(junit:junit)
BuildRequires: mvn(log4j:log4j:1.2.17)
BuildRequires: mvn(net.sf.cglib:cglib)

BuildArch: noarch
Source44: import.info

%description
Transparently adds connection pooling to your existing JDBC driver.
Complies with the J2SE API, giving you the confidence to develop to
standards. You can monitor the performance of your database
connections and listen to connection events.
It's easy to configure using the JDBC API, XML, or Java property
files - you decide.

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n %{name}-%{name}-%{git_commit}
#find . -name "*.jar" -exec rm {} \;
find . -type f -a -executable -exec chmod -x {} \;
rm -rf lib jarjar

%patch0 -p1 -b .sav0

sed -i.new_checkstyle "s|com.puppycrawl.tools.checkstyle.CheckStyleTask|com.puppycrawl.tools.checkstyle.ant.CheckstyleAntTask|" build.xml

sed -i.doclint "s|public="true"|public="true" additionalparam="-Xdoclint:none"|" build.xml

%mvn_file %{name}:%{name} %{name}

%build
CLASSPATH=$(build-classpath cglib avalon-framework glassfish-servlet-api) ant build-jar javadoc

%install
%mvn_artifact %{SOURCE1} build/%{name}-%{version}.jar
%mvn_install -J build/api

%files -f .mfiles
%doc CHANGES.txt README.txt
%doc --no-dereference LICENCE.txt

%files javadoc -f .mfiles-javadoc
%doc --no-dereference LICENCE.txt

%changelog
