Name: pve-cluster
Summary: Cluster Infrastructure for PVE
Version: 6.2.1
Release: alt1
License: GPLv3
Group: System/Servers
Url: https://git.proxmox.com/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

ExclusiveArch: x86_64 aarch64
Requires: bridge-utils chrony ntpdate corosync2 fuse rrd-cached ksmtuned openvswitch
Requires: sqlite3 vixie-cron faketime tzdata openssh-server openssh-clients

Source0: %name.tar.xz
Source1: pve-access-control.tar.xz
Source2: pve-apiclient.tar.xz

Patch0: %name.patch
Patch1: pve-access-control.patch
Patch2: pve-cluster-install_vzdump_cron_config.patch
Patch3: pve-cluster-get_guest_config_property.patch

Source3: %name.filetrigger

BuildRequires: pve-common pve-doc-generator libcheck-devel librrd-devel glib2-devel libfuse-devel libcorosync2-devel libsqlite3-devel xmlto
BuildRequires: perl(ExtUtils/Embed.pm) perl(Term/ReadLine.pm) perl(Digest/HMAC_SHA1.pm) perl(XML/Parser.pm) perl(RRDs.pm)
BuildRequires: perl(Crypt/OpenSSL/Random.pm) perl(Crypt/OpenSSL/RSA.pm) perl(Net/SSLeay.pm)
BuildRequires: perl(MIME/Base32.pm) perl(Net/LDAP.pm) perl(Authen/PAM.pm) perl(UUID.pm)

%description
This package contains the Cluster Infrastructure for the PVE,
namely a distributed filesystem to store configuration data
on all nodes.

%package -n pve-access-control
Summary: PVE access control library
Version: 6.1.3
Group: Development/Perl

%description -n pve-access-control
This package contains the role based user management and access
control function used by PVE.

%prep
%setup -q -n %name -a1 -a2
%patch0 -p1
%patch1 -p0
%patch2 -p1
%patch3 -p1

grep '/var/run' * -rl | while read f; do
    sed -i 's|/var/run|/run|' $f
done

%install
install -pD -m644 debian/%name.service %buildroot%systemd_unitdir/%name.service
install -pD -m644 debian/sysctl.d/pve.conf %buildroot%_sysconfdir/sysctl.d/pve-cluster.conf
cd data
%make -C PVE/Cluster DESTDIR=%buildroot install
%make PERL_DOC_INC_DIRS=" .. . ../../pve-access-control ../../pve-apiclient" DESTDIR=%buildroot install
cd ../pve-access-control
%make DESTDIR=%buildroot install
cd ../pve-apiclient
%make DESTDIR=%buildroot install

install -pD -m0755 %SOURCE3 %buildroot%_prefix/lib/rpm/%name.filetrigger

mkdir -p %buildroot%_sysconfdir/cron.d
touch %buildroot%_sysconfdir/cron.d/vzdump

mkdir -p %buildroot%_localstatedir/%name

mkdir -p %buildroot%_sysconfdir/network
cat << __EOF__ > %buildroot%_sysconfdir/network/interfaces
auto lo
iface lo inet loopback
__EOF__

mkdir -p %buildroot%_sysconfdir/sysconfig
cat << __EOF__ > %buildroot%_sysconfdir/sysconfig/%name
DAEMON_OPTS=""
__EOF__

mkdir -p %buildroot%_localstatedir/rrdcached/{db,journal}
mkdir -p %buildroot%_sysconfdir/systemd/system
cat << __EOF__ > %buildroot%_sysconfdir/systemd/system/rrdcached.socket
[Unit]
Description=sockets activating rrdcached

[Socket]
ListenStream=/run/rrdcached.sock
SocketMode=0660

[Install]
WantedBy=sockets.target
__EOF__

cat << __EOF__ > %buildroot%_sysconfdir/systemd/system/rrdcached.service
[Unit]
Description=Data caching daemon for rrdtool
After=network.service

[Service]
Type=forking
PIDFile=/run/rrdcached.pid
ExecStart=/usr/bin/rrdcached -j /var/lib/rrdcached/journal/ -F -b /var/lib/rrdcached/db/ -B -p /run/rrdcached.pid -l /run/rrdcached.sock

[Install]
Also=rrdcached.socket
WantedBy=default.target
__EOF__

%post
%post_service %name

%preun
%preun_service %name
if [ $1 -eq 0 ] ; then
        /sbin/systemctl disable %name.service >/dev/null 2>&1 || :
fi

%pre
%_sbindir/groupadd -r -f www-data 2>/dev/null ||:
%_sbindir/useradd -g www-data -c 'www-data' -d /var/www -s '/sbin/nologin' -G www-data -r www-data 2>/dev/null || :

%triggerun -- %name <= 4.0.48-alt7
if [ -L %_sysconfdir/cron.d/vzdump ]; then
	rm -f %_sysconfdir/cron.d/vzdump
fi

%files
%_sysconfdir/systemd/system/rrdcached.s*
%systemd_unitdir/%name.service
%_sysconfdir/bash_completion.d/pvecm
%dir %_sysconfdir/network
%ghost %_sysconfdir/network/interfaces
%ghost %_sysconfdir/cron.d/vzdump
%_sysconfdir/sysctl.d/pve-cluster.conf
%_bindir/create_pmxcfs_db
%_bindir/pmxcfs
%_bindir/pvecm
%dir %perl_vendor_autolib/PVE
%perl_vendor_autolib/PVE/IPCC
%dir %perl_vendor_privlib/PVE
%perl_vendor_privlib/PVE/Cluster.pm
%perl_vendor_privlib/PVE/Corosync.pm
%perl_vendor_privlib/PVE/IPCC.pm
%dir %perl_vendor_privlib/PVE/CLI
%perl_vendor_privlib/PVE/CLI/pvecm.pm
%dir %perl_vendor_privlib/PVE/APIClient
%perl_vendor_privlib/PVE/APIClient/Exception.pm
%perl_vendor_privlib/PVE/APIClient/LWP.pm
%perl_vendor_privlib/PVE/DataCenterConfig.pm
%perl_vendor_privlib/PVE/RRD.pm
%perl_vendor_privlib/PVE/SSHInfo.pm
%dir %perl_vendor_privlib/PVE/Cluster
%perl_vendor_privlib/PVE/Cluster/IPCConst.pm
%perl_vendor_privlib/PVE/Cluster/Setup.pm
%dir %_localstatedir/%name
%dir %_localstatedir/rrdcached/db
%dir %_localstatedir/rrdcached/journal
%_datadir/zsh/vendor-completions/_pvecm
%_man1dir/pvecm.1*
%_man5dir/datacenter.cfg.5*
%_man8dir/pmxcfs.8*
%_prefix/lib/rpm/%name.filetrigger

%files -n pve-access-control
%_sysconfdir/bash_completion.d/pveum
%_bindir/oathkeygen
%_sbindir/pveum
%dir %perl_vendor_privlib/PVE
%perl_vendor_privlib/PVE/RPCEnvironment.pm
%perl_vendor_privlib/PVE/AccessControl.pm
%perl_vendor_privlib/PVE/TokenConfig.pm
%dir %perl_vendor_privlib/PVE/CLI
%perl_vendor_privlib/PVE/CLI/pveum.pm
%dir %perl_vendor_privlib/PVE/API2
%perl_vendor_privlib/PVE/API2/*.pm
%dir %perl_vendor_privlib/PVE/Auth
%perl_vendor_privlib/PVE/Auth/*.pm
%_datadir/zsh/vendor-completions/_pveum
%_man1dir/pveum.1*

%changelog
