%def_enable check

Name: pve-common
Summary: PVE base library
Version: 6.3.2
Release: alt1
License: GPLv3
Group: Development/Perl
Url: https://git.proxmox.com/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: %name-%version.tar

BuildArch: noarch
BuildRequires: perl-ph
BuildRequires: perl(IO/Socket/IP.pm)
BuildRequires: perl(Filesys/Df.pm)
BuildRequires: perl(URI/Escape.pm)
BuildRequires: perl(Digest/SHA.pm)
BuildRequires: perl(String/ShellQuote.pm)
BuildRequires: perl(IO/AtomicFile.pm)
BuildRequires: perl(HTTP/Status.pm)
BuildRequires: perl(Devel/Cycle.pm)
BuildRequires: perl(Net/IP.pm)
BuildRequires: perl(Net/DBus.pm)
BuildRequires: perl(Pod/Parser.pm)
BuildRequires: perl(Clone.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(Linux/Inotify2.pm)
BuildRequires: perl(JSON.pm)
BuildRequires: perl(MIME/Base32.pm)
BuildRequires: perl(Crypt/OpenSSL/Random.pm)
BuildRequires: perl(Crypt/OpenSSL/RSA.pm)
BuildRequires: perl(Date/Parse.pm)
BuildRequires: perl(Net/SSLeay.pm)
BuildRequires: perl(HTTP/Daemon.pm)
BuildRequires: perl(CPAN/Meta/YAML.pm)
BuildRequires: perl(Net/LDAP.pm)
# alt regressive tests
BuildRequires: perl(TAP/Harness.pm)
BuildRequires: perl(Test/MockModule.pm)

%description
This package contains the base library used by other PVE components.

%prep
%setup -q -n %name-%version
sed -i 's|Proxmox VE|PVE|' src/PVE/Tools.pm

%install
cd src
%make DESTDIR=%buildroot install
cd ..
install -pD -m0755 pve-etcnet-to-network %buildroot%_sbindir/pve-etcnet-to-network

%if_enabled check
%check
# upstream tests
make -C test check
# etcnet tests
./runtests.pl
%endif

%files
%_sbindir/pve-etcnet-to-network
%perl_vendor_privlib/PVE

%changelog
